/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.model;

import java.io.Serializable;
import java.util.Properties;

public class ScanConfiguration
implements Serializable {
    private static final long serialVersionUID = -4079386431705567945L;
    private Properties properties;

    public ScanConfiguration() {
    }

    public ScanConfiguration(Properties properties) {
        this.setProperties(properties);
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperty(Object key, Object value) {
        if (value != null) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put(key, value);
        } else if (this.properties != null) {
            this.properties.remove(key);
        }
    }

    public String getString(String defaultValue, String ... keys) {
        if (this.properties != null) {
            for (String key : keys) {
                Object value = this.properties.get(key);
                if (!(value instanceof String)) continue;
                return (String)value;
            }
        }
        return defaultValue;
    }

    public int getInteger(int defaultValue, String ... keys) {
        if (this.properties != null) {
            for (String key : keys) {
                Object value = this.properties.get(key);
                if (value instanceof Number) {
                    return ((Number)value).intValue();
                }
                try {
                    return Integer.valueOf((String)value);
                }
                catch (Exception exception) {
                }
            }
        }
        return defaultValue;
    }

    public boolean getBoolean(boolean defaultValue, String ... keys) {
        if (this.properties != null) {
            for (String key : keys) {
                Object value = this.properties.get(key);
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                if (!(value instanceof String)) continue;
                return Boolean.parseBoolean((String)value);
            }
        }
        return defaultValue;
    }

    public String toString() {
        return String.valueOf(this.properties);
    }
}

