/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.persist.internal;

import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.ldap.persist.internal.LdapConfigurationData;
import org.sonatype.nexus.ldap.persist.internal.LdapConfigurationSource;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="ldapConfigurationExport")
@Singleton
public class LdapConfigurationExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final LdapConfigurationSource policySource;

    @Inject
    public LdapConfigurationExport(LdapConfigurationSource policySource) {
        this.policySource = policySource;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export LdapConfiguration data to {}", (Object)file);
        List<LdapConfiguration> cleanupPolicies = this.policySource.loadAll();
        this.exportToJson(cleanupPolicies, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring LdapConfiguration data from {}", (Object)file);
        this.importFromJson(file, LdapConfigurationData.class).forEach(this.policySource::create);
    }
}

