/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.model;

import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.sonatype.nexus.ldap.model.AuthScheme;
import org.sonatype.nexus.ldap.model.GroupDynamic;
import org.sonatype.nexus.ldap.model.GroupStatic;
import org.sonatype.nexus.ldap.model.GroupType;
import org.sonatype.nexus.ldap.model.LdapAuthScheme;
import org.sonatype.nexus.ldap.model.LdapProtocol;
import org.sonatype.nexus.ldap.persist.entity.Connection;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.ldap.persist.entity.Mapping;
import org.sonatype.nexus.validation.constraint.Hostname;
import org.sonatype.nexus.validation.constraint.PortNumber;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class LdapServerXo {
    @ApiModelProperty(value="LDAP server name", required=true)
    @NotEmpty
    private String name;
    @ApiModelProperty(value="LDAP server connection Protocol to use", allowableValues="ldap,ldaps", required=true)
    @NotNull
    private LdapProtocol protocol;
    @ApiModelProperty(value="Whether to use certificates stored in Nexus Repository Manager's truststore")
    private boolean useTrustStore;
    @ApiModelProperty(value="LDAP server connection hostname", required=true)
    @NotEmpty
    @Hostname
    private String host;
    @ApiModelProperty(value="LDAP server connection port to use", example="636", required=true)
    @NotNull
    @PortNumber
    private Integer port;
    @ApiModelProperty(value="LDAP location to be added to the connection URL", example="dc=example,dc=com", required=true)
    @NotEmpty
    private String searchBase;
    @ApiModelProperty(value="Authentication scheme used for connecting to LDAP server", allowableValues="NONE,SIMPLE,DIGEST_MD5,CRAM_MD5", required=true)
    @NotNull
    private LdapAuthScheme authScheme;
    @ApiModelProperty(value="The SASL realm to bind to. Required if authScheme is CRAM_MD5 or DIGEST_MD5", example="example.com")
    private String authRealm;
    @ApiModelProperty(value="This must be a fully qualified username if simple authentication is used. Required if authScheme other than none.")
    @NotEmpty(groups={AuthScheme.class})
    private String authUsername;
    @ApiModelProperty(value="How long to wait before timeout", example="1")
    @Min(value=1L)
    @Max(value=3600L)
    @NotNull
    private @Min(value=1L) @Max(value=3600L) @NotNull Integer connectionTimeoutSeconds;
    @ApiModelProperty(value="How long to wait before retrying")
    @Min(value=0L)
    @NotNull
    private @Min(value=0L) @NotNull Integer connectionRetryDelaySeconds;
    @ApiModelProperty(value="How many retry attempts")
    @Min(value=0L)
    @NotNull
    private @Min(value=0L) @NotNull Integer maxIncidentsCount;
    @ApiModelProperty(value="The relative DN where user objects are found (e.g. ou=people). This value will have the Search base DN value appended to form the full User search base DN.", example="ou=people")
    private String userBaseDn;
    @ApiModelProperty(value="Are users located in structures below the user base DN?")
    private boolean userSubtree;
    @ApiModelProperty(value="LDAP class for user objects", example="inetOrgPerson")
    @NotEmpty
    private String userObjectClass;
    @ApiModelProperty(value="LDAP search filter to limit user search", example="(|(mail=*@example.com)(uid=dom*))")
    private String userLdapFilter;
    @ApiModelProperty(value="This is used to find a user given its user ID", example="uid")
    @NotEmpty
    private String userIdAttribute;
    @ApiModelProperty(value="This is used to find a real name given the user ID", example="cn")
    @NotEmpty
    private String userRealNameAttribute;
    @ApiModelProperty(value="This is used to find an email address given the user ID", example="mail")
    @NotEmpty
    private String userEmailAddressAttribute;
    @ApiModelProperty(value="If this field is blank the user will be authenticated against a bind with the LDAP server")
    private String userPasswordAttribute;
    @ApiModelProperty(value="Denotes whether LDAP assigned roles are used as Nexus Repository Manager roles")
    private boolean ldapGroupsAsRoles;
    @ApiModelProperty(value="Defines a type of groups used: static (a group contains a list of users) or dynamic (a user contains a list of groups). Required if ldapGroupsAsRoles is true.", allowableValues="static,dynamic")
    @NotNull(groups={GroupDynamic.class, GroupStatic.class})
    private GroupType groupType;
    @ApiModelProperty(value="The relative DN where group objects are found (e.g. ou=Group). This value will have the Search base DN value appended to form the full Group search base DN.", example="ou=Group")
    private String groupBaseDn;
    @ApiModelProperty(value="Are groups located in structures below the group base DN")
    private boolean groupSubtree;
    @ApiModelProperty(value="LDAP class for group objects. Required if groupType is static", example="posixGroup")
    @Size(groups={GroupDynamic.class}, max=0)
    @NotEmpty(groups={GroupStatic.class})
    private @Size(groups={GroupDynamic.class}, max=0) @NotEmpty(groups={GroupStatic.class}) String groupObjectClass;
    @ApiModelProperty(value="This field specifies the attribute of the Object class that defines the Group ID. Required if groupType is static", example="cn")
    @Size(groups={GroupDynamic.class}, max=0)
    @NotEmpty(groups={GroupStatic.class})
    private @Size(groups={GroupDynamic.class}, max=0) @NotEmpty(groups={GroupStatic.class}) String groupIdAttribute;
    @ApiModelProperty(value="LDAP attribute containing the usernames for the group. Required if groupType is static", example="memberUid")
    @Size(groups={GroupDynamic.class}, max=0)
    @NotEmpty(groups={GroupStatic.class})
    private @Size(groups={GroupDynamic.class}, max=0) @NotEmpty(groups={GroupStatic.class}) String groupMemberAttribute;
    @ApiModelProperty(value="The format of user ID stored in the group member attribute. Required if groupType is static", example="uid=${username},ou=people,dc=example,dc=com")
    @Size(groups={GroupDynamic.class}, max=0)
    @NotEmpty(groups={GroupStatic.class})
    private @Size(groups={GroupDynamic.class}, max=0) @NotEmpty(groups={GroupStatic.class}) String groupMemberFormat;
    @ApiModelProperty(value="Set this to the attribute used to store the attribute which holds groups DN in the user object. Required if groupType is dynamic", example="memberOf")
    @Size(groups={GroupStatic.class}, max=0)
    @NotEmpty(groups={GroupDynamic.class})
    private @Size(groups={GroupStatic.class}, max=0) @NotEmpty(groups={GroupDynamic.class}) String userMemberOfAttribute;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LdapProtocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(LdapProtocol protocol) {
        this.protocol = protocol;
    }

    public boolean isUseTrustStore() {
        return this.useTrustStore;
    }

    public void setUseTrustStore(boolean useTrustStore) {
        this.useTrustStore = useTrustStore;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public LdapAuthScheme getAuthScheme() {
        return this.authScheme;
    }

    public void setAuthScheme(LdapAuthScheme authScheme) {
        this.authScheme = authScheme;
    }

    public String getAuthRealm() {
        return this.authRealm;
    }

    public void setAuthRealm(String authRealm) {
        this.authRealm = authRealm;
    }

    public String getAuthUsername() {
        return this.authUsername;
    }

    public void setAuthUsername(String authUsername) {
        this.authUsername = authUsername;
    }

    public Integer getConnectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds;
    }

    public void setConnectionTimeoutSeconds(Integer connectionTimeoutSeconds) {
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
    }

    public Integer getConnectionRetryDelaySeconds() {
        return this.connectionRetryDelaySeconds;
    }

    public void setConnectionRetryDelaySeconds(Integer connectionRetryDelaySeconds) {
        this.connectionRetryDelaySeconds = connectionRetryDelaySeconds;
    }

    public Integer getMaxIncidentsCount() {
        return this.maxIncidentsCount;
    }

    public void setMaxIncidentsCount(Integer maxIncidentsCount) {
        this.maxIncidentsCount = maxIncidentsCount;
    }

    public String getUserBaseDn() {
        return this.userBaseDn;
    }

    public void setUserBaseDn(String userBaseDn) {
        this.userBaseDn = userBaseDn;
    }

    public boolean isUserSubtree() {
        return this.userSubtree;
    }

    public void setUserSubtree(boolean userSubtree) {
        this.userSubtree = userSubtree;
    }

    public String getUserObjectClass() {
        return this.userObjectClass;
    }

    public void setUserObjectClass(String userObjectClass) {
        this.userObjectClass = userObjectClass;
    }

    public String getUserLdapFilter() {
        return this.userLdapFilter;
    }

    public void setUserLdapFilter(String userLdapFilter) {
        this.userLdapFilter = userLdapFilter;
    }

    public String getUserIdAttribute() {
        return this.userIdAttribute;
    }

    public void setUserIdAttribute(String userIdAttribute) {
        this.userIdAttribute = userIdAttribute;
    }

    public String getUserRealNameAttribute() {
        return this.userRealNameAttribute;
    }

    public void setUserRealNameAttribute(String userRealNameAttribute) {
        this.userRealNameAttribute = userRealNameAttribute;
    }

    public String getUserEmailAddressAttribute() {
        return this.userEmailAddressAttribute;
    }

    public void setUserEmailAddressAttribute(String userEmailAddressAttribute) {
        this.userEmailAddressAttribute = userEmailAddressAttribute;
    }

    public String getUserPasswordAttribute() {
        return this.userPasswordAttribute;
    }

    public void setUserPasswordAttribute(String userPasswordAttribute) {
        this.userPasswordAttribute = userPasswordAttribute;
    }

    public boolean isLdapGroupsAsRoles() {
        return this.ldapGroupsAsRoles;
    }

    public void setLdapGroupsAsRoles(boolean ldapGroupsAsRoles) {
        this.ldapGroupsAsRoles = ldapGroupsAsRoles;
    }

    public GroupType getGroupType() {
        return this.groupType;
    }

    public void setGroupType(GroupType groupType) {
        this.groupType = groupType;
    }

    public String getGroupBaseDn() {
        return this.groupBaseDn;
    }

    public void setGroupBaseDn(String groupBaseDn) {
        this.groupBaseDn = groupBaseDn;
    }

    public boolean isGroupSubtree() {
        return this.groupSubtree;
    }

    public void setGroupSubtree(boolean groupSubtree) {
        this.groupSubtree = groupSubtree;
    }

    public String getGroupObjectClass() {
        return this.groupObjectClass;
    }

    public void setGroupObjectClass(String groupObjectClass) {
        this.groupObjectClass = groupObjectClass;
    }

    public String getGroupIdAttribute() {
        return this.groupIdAttribute;
    }

    public void setGroupIdAttribute(String groupIdAttribute) {
        this.groupIdAttribute = groupIdAttribute;
    }

    public String getGroupMemberAttribute() {
        return this.groupMemberAttribute;
    }

    public void setGroupMemberAttribute(String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
    }

    public String getGroupMemberFormat() {
        return this.groupMemberFormat;
    }

    public void setGroupMemberFormat(String groupMemberFormat) {
        this.groupMemberFormat = groupMemberFormat;
    }

    public String getUserMemberOfAttribute() {
        return this.userMemberOfAttribute;
    }

    public void setUserMemberOfAttribute(String userMemberOfAttribute) {
        this.userMemberOfAttribute = userMemberOfAttribute;
    }

    public LdapConfiguration toLdapConfiguration(LdapConfiguration ldapConfiguration) {
        Mapping mapping = new Mapping();
        mapping.setUserBaseDn(this.userBaseDn);
        mapping.setUserSubtree(this.userSubtree);
        mapping.setUserObjectClass(this.userObjectClass);
        mapping.setLdapFilter(this.userLdapFilter);
        mapping.setUserIdAttribute(this.userIdAttribute);
        mapping.setUserRealNameAttribute(this.userRealNameAttribute);
        mapping.setEmailAddressAttribute(this.userEmailAddressAttribute);
        mapping.setUserPasswordAttribute(this.userPasswordAttribute);
        mapping.setLdapGroupsAsRoles(this.ldapGroupsAsRoles);
        if (this.ldapGroupsAsRoles) {
            if (GroupType.DYNAMIC.equals((Object)this.groupType)) {
                mapping.setUserMemberOfAttribute(this.userMemberOfAttribute);
            } else if (GroupType.STATIC.equals((Object)this.groupType)) {
                mapping.setGroupBaseDn(this.groupBaseDn);
                mapping.setGroupSubtree(this.groupSubtree);
                mapping.setGroupIdAttribute(this.groupIdAttribute);
                mapping.setGroupMemberAttribute(this.groupMemberAttribute);
                mapping.setGroupMemberFormat(this.groupMemberFormat);
                mapping.setGroupObjectClass(this.groupObjectClass);
            }
        }
        Connection connection = new Connection();
        connection.setHost(new Connection.Host(Connection.Protocol.valueOf(this.protocol.toString().toLowerCase()), this.host, this.port));
        connection.setUseTrustStore(this.useTrustStore);
        connection.setSearchBase(this.searchBase);
        connection.setAuthScheme(this.authScheme.toString());
        connection.setSaslRealm(this.authRealm);
        connection.setSystemUsername(this.authUsername);
        connection.setConnectionTimeout(this.connectionTimeoutSeconds);
        connection.setConnectionRetryDelay(this.connectionRetryDelaySeconds);
        connection.setMaxIncidentsCount(this.maxIncidentsCount);
        ldapConfiguration.setId(null);
        ldapConfiguration.setName(this.name);
        ldapConfiguration.setConnection(connection);
        ldapConfiguration.setMapping(mapping);
        return ldapConfiguration;
    }
}

