/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.ui;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.ldap.internal.LdapURL;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapConnectionTester;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUser;
import org.sonatype.nexus.ldap.internal.realms.EnterpriseLdapManager;
import org.sonatype.nexus.ldap.internal.realms.LdapConnectionUtils;
import org.sonatype.nexus.ldap.internal.templates.LdapSchemaTemplate;
import org.sonatype.nexus.ldap.internal.templates.LdapSchemaTemplateManager;
import org.sonatype.nexus.ldap.internal.ui.LdapSchemaTemplateXO;
import org.sonatype.nexus.ldap.internal.ui.LdapServerConnectionXO;
import org.sonatype.nexus.ldap.internal.ui.LdapServerXO;
import org.sonatype.nexus.ldap.internal.ui.ReferenceXO;
import org.sonatype.nexus.ldap.persist.LdapConfigurationManager;
import org.sonatype.nexus.ldap.persist.entity.Connection;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.ldap.persist.entity.Mapping;
import org.sonatype.nexus.ssl.TrustStore;
import org.sonatype.nexus.validation.Validate;
import org.sonatype.nexus.validation.group.Create;
import org.sonatype.nexus.validation.group.Update;

@Named
@Singleton
@DirectAction(action={"ldap_LdapServer"})
public class LdapServerComponent
extends DirectComponentSupport
implements GroovyObject {
    @Inject
    private LdapConfigurationManager ldapConfigurationManager;
    @Inject
    private LdapSchemaTemplateManager templateManager;
    @Inject
    private LdapConnectionTester ldapConnectionTester;
    @Inject
    private EnterpriseLdapManager ldapManager;
    @Inject
    private TrustStore trustStore;
    @Inject
    private Validator validator;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public LdapServerComponent() {
        MetaClass metaClass;
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:ldap:read"})
    public List<LdapServerXO> read() {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Reference counter = new Reference((Object)1);
        public class _read_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference counter;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _read_closure1(Object _outerInstance, Object _thisObject, Reference counter) {
                Reference reference;
                CallSite[] callSiteArray = _read_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.counter = reference = counter;
            }

            public Object doCall(Object input) {
                CallSite[] callSiteArray = _read_closure1.$getCallSiteArray();
                public class _closure5
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference counter;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _closure5(Object _outerInstance, Object _thisObject, Reference counter) {
                        Reference reference;
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.counter = reference = counter;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        Object object = this.counter.get();
                        this.counter.set(callSiteArray[0].call(object));
                        Object object2 = object;
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, _closure5.class, (GroovyObject)this, (String)"order");
                        return it;
                    }

                    public Object getCounter() {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return this.counter.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure5.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure5.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "next";
                        return new CallSiteArray(_closure5.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure5.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                return callSiteArray[0].call(callSiteArray[1].callCurrent((GroovyObject)this, input), (Object)new _closure5((Object)this, this.getThisObject(), this.counter));
            }

            public Object getCounter() {
                CallSite[] callSiteArray = _read_closure1.$getCallSiteArray();
                return this.counter.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _read_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "with";
                stringArray[1] = "asLdapServerXO";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _read_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_read_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _read_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].call(callSiteArray[1].call((Object)this.ldapConfigurationManager), (Object)new _read_closure1((Object)this, (Object)this, counter)), List.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:ldap:read"})
    public List<ReferenceXO> readReferences() {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        public class _readReferences_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _readReferences_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _readReferences_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object input) {
                CallSite[] callSiteArray = _readReferences_closure2.$getCallSiteArray();
                return callSiteArray[0].callConstructor(ReferenceXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", callSiteArray[1].callGetProperty(input), "name", callSiteArray[2].callGetProperty(input)}));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _readReferences_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "id";
                stringArray[2] = "name";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _readReferences_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_readReferences_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _readReferences_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].call(callSiteArray[3].call((Object)this.ldapConfigurationManager), (Object)new _readReferences_closure2((Object)this, (Object)this)), List.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:ldap:read"})
    public List<LdapSchemaTemplateXO> readTemplates() {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        public class _readTemplates_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _readTemplates_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _readTemplates_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object template) {
                CallSite[] callSiteArray = _readTemplates_closure3.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, template);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _readTemplates_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "asLdapSchemaTemplateXO";
                return new CallSiteArray(_readTemplates_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _readTemplates_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].call(callSiteArray[5].callGetProperty((Object)this.templateManager), (Object)new _readTemplates_closure3((Object)this, (Object)this)), List.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:create"})
    @Validate(groups={Create.class, Default.class})
    public LdapServerXO create(@NotNull @Valid LdapServerXO ldapServerXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Object id = callSiteArray[6].call((Object)this.ldapConfigurationManager, callSiteArray[7].callCurrent((GroovyObject)this, callSiteArray[8].callCurrent((GroovyObject)this, (Object)ldapServerXO)));
        return (LdapServerXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[9].callCurrent((GroovyObject)this, callSiteArray[10].call((Object)this.ldapConfigurationManager, id)), LdapServerXO.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    @Validate(groups={Update.class, Default.class})
    public LdapServerXO update(@NotNull @Valid LdapServerXO ldapServerXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        LdapConfiguration existing = (LdapConfiguration)ScriptBytecodeAdapter.castToType((Object)callSiteArray[11].call((Object)this.ldapConfigurationManager, callSiteArray[12].callGroovyObjectGetProperty((Object)ldapServerXO)), LdapConfiguration.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)existing)) {
            callSiteArray[13].call((Object)this.ldapConfigurationManager, callSiteArray[14].callCurrent((GroovyObject)this, callSiteArray[15].callCurrent((GroovyObject)this, (Object)ldapServerXO)));
            return (LdapServerXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[16].callCurrent((GroovyObject)this, callSiteArray[17].call((Object)this.ldapConfigurationManager, callSiteArray[18].callGroovyObjectGetProperty((Object)ldapServerXO))), LdapServerXO.class);
        }
        throw (Throwable)callSiteArray[19].callConstructor(IllegalArgumentException.class, callSiteArray[20].call(callSiteArray[21].call((Object)"LDAP server with id \"", callSiteArray[22].callGroovyObjectGetProperty((Object)ldapServerXO)), (Object)"\" not found"));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:delete"})
    @Validate
    public void remove(@NotEmpty String id) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        callSiteArray[23].call((Object)this.ldapConfigurationManager, (Object)id);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    public void changeOrder(List<String> orderedServerIds) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        callSiteArray[24].call((Object)this.ldapConfigurationManager, orderedServerIds);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:delete"})
    public void clearCache() {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        callSiteArray[25].call((Object)this.ldapConfigurationManager);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    @Validate
    public void verifyConnection(@NotNull @Valid LdapServerConnectionXO ldapServerConnectionXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        try {
            callSiteArray[26].call((Object)this.ldapConnectionTester, callSiteArray[27].callCurrent((GroovyObject)this, callSiteArray[28].callCurrent((GroovyObject)this, (Object)ldapServerConnectionXO)));
        }
        catch (Exception e) {
            callSiteArray[29].call(callSiteArray[30].callGroovyObjectGetProperty((Object)this), callSiteArray[31].call((Object)e), (Object)e);
            throw (Throwable)callSiteArray[32].callConstructor(Exception.class, callSiteArray[33].callCurrent((GroovyObject)this, (Object)ldapServerConnectionXO));
        }
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    @Validate
    public Collection<LdapUser> verifyUserMapping(@NotNull @Valid LdapServerXO ldapServerXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Collection collection = (Collection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[34].call((Object)this.ldapConnectionTester, callSiteArray[35].callCurrent((GroovyObject)this, callSiteArray[36].callCurrent((GroovyObject)this, (Object)ldapServerXO)), callSiteArray[37].call(LdapConnectionUtils.class, callSiteArray[38].callCurrent((GroovyObject)this, (Object)ldapServerXO)), (Object)20), Collection.class);
        try {
            return collection;
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[39].callConstructor(Exception.class, callSiteArray[40].callCurrent((GroovyObject)this, (Object)"Failed to connect to LDAP Server", (Object)e));
        }
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    @Validate
    public void verifyLogin(@NotNull @Valid LdapServerXO ldapServerXO, @NotEmpty String base64Username, @NotEmpty String base64Password) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        try {
            callSiteArray[41].call((Object)this.ldapManager, callSiteArray[42].call(Strings2.class, (Object)base64Username), callSiteArray[43].call(Strings2.class, (Object)base64Password), callSiteArray[44].callCurrent((GroovyObject)this, callSiteArray[45].callCurrent((GroovyObject)this, (Object)ldapServerXO)));
        }
        catch (Exception e) {
            throw (Throwable)callSiteArray[46].callConstructor(Exception.class, callSiteArray[47].callCurrent((GroovyObject)this, (Object)"Failed to connect to LDAP Server", (Object)e));
        }
    }

    LdapServerXO asLdapServerXO(LdapConfiguration ldapServer) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Connection connectionInfo = (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[48].callGetProperty((Object)ldapServer), Connection.class);
        Mapping userAndGroupConfig = (Mapping)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].callGetProperty((Object)ldapServer), Mapping.class);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object[] objectArray = new Object[62];
            objectArray[0] = "id";
            objectArray[1] = callSiteArray[51].callGetProperty((Object)ldapServer);
            objectArray[2] = "name";
            objectArray[3] = callSiteArray[52].callGetProperty((Object)ldapServer);
            objectArray[4] = "url";
            objectArray[5] = callSiteArray[53].callCurrent((GroovyObject)this, (Object)connectionInfo);
            objectArray[6] = "protocol";
            objectArray[7] = callSiteArray[54].call(callSiteArray[55].callGetProperty(callSiteArray[56].callGetProperty((Object)connectionInfo)));
            objectArray[8] = "useTrustStore";
            objectArray[9] = callSiteArray[57].callGetProperty((Object)connectionInfo);
            objectArray[10] = "host";
            objectArray[11] = callSiteArray[58].callGetProperty(callSiteArray[59].callGetProperty((Object)connectionInfo));
            objectArray[12] = "port";
            objectArray[13] = callSiteArray[60].callGetProperty(callSiteArray[61].callGetProperty((Object)connectionInfo));
            objectArray[14] = "searchBase";
            objectArray[15] = callSiteArray[62].callGetProperty((Object)connectionInfo);
            objectArray[16] = "authScheme";
            objectArray[17] = callSiteArray[63].callGetProperty((Object)connectionInfo);
            objectArray[18] = "authRealm";
            objectArray[19] = callSiteArray[64].callGetProperty((Object)connectionInfo);
            objectArray[20] = "authUsername";
            objectArray[21] = callSiteArray[65].callGetProperty((Object)connectionInfo);
            objectArray[22] = "connectionTimeout";
            objectArray[23] = callSiteArray[66].callGetProperty((Object)connectionInfo);
            objectArray[24] = "connectionRetryDelay";
            objectArray[25] = callSiteArray[67].callGetProperty((Object)connectionInfo);
            objectArray[26] = "maxIncidentsCount";
            objectArray[27] = callSiteArray[68].callGetProperty((Object)connectionInfo);
            objectArray[28] = "userBaseDn";
            objectArray[29] = callSiteArray[69].callGetProperty((Object)userAndGroupConfig);
            objectArray[30] = "userSubtree";
            objectArray[31] = callSiteArray[70].callGetProperty((Object)userAndGroupConfig);
            objectArray[32] = "userObjectClass";
            objectArray[33] = callSiteArray[71].callGetProperty((Object)userAndGroupConfig);
            objectArray[34] = "userLdapFilter";
            objectArray[35] = callSiteArray[72].callGetProperty((Object)userAndGroupConfig);
            objectArray[36] = "userIdAttribute";
            objectArray[37] = callSiteArray[73].callGetProperty((Object)userAndGroupConfig);
            objectArray[38] = "userRealNameAttribute";
            objectArray[39] = callSiteArray[74].callGetProperty((Object)userAndGroupConfig);
            objectArray[40] = "userEmailAddressAttribute";
            objectArray[41] = callSiteArray[75].callGetProperty((Object)userAndGroupConfig);
            objectArray[42] = "userPasswordAttribute";
            objectArray[43] = callSiteArray[76].callGetProperty((Object)userAndGroupConfig);
            objectArray[44] = "ldapGroupsAsRoles";
            objectArray[45] = callSiteArray[77].callGetProperty((Object)userAndGroupConfig);
            objectArray[46] = "groupType";
            objectArray[47] = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[78].callGetProperty((Object)userAndGroupConfig)) ? (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[79].callGetProperty((Object)userAndGroupConfig)) ? "dynamic" : "static") : null;
            objectArray[48] = "userMemberOfAttribute";
            objectArray[49] = callSiteArray[80].callGetProperty((Object)userAndGroupConfig);
            objectArray[50] = "groupBaseDn";
            objectArray[51] = callSiteArray[81].callGetProperty((Object)userAndGroupConfig);
            objectArray[52] = "groupSubtree";
            objectArray[53] = callSiteArray[82].callGetProperty((Object)userAndGroupConfig);
            objectArray[54] = "groupIdAttribute";
            objectArray[55] = callSiteArray[83].callGetProperty((Object)userAndGroupConfig);
            objectArray[56] = "groupMemberAttribute";
            objectArray[57] = callSiteArray[84].callGetProperty((Object)userAndGroupConfig);
            objectArray[58] = "groupMemberFormat";
            objectArray[59] = callSiteArray[85].callGetProperty((Object)userAndGroupConfig);
            objectArray[60] = "groupObjectClass";
            objectArray[61] = callSiteArray[86].callGetProperty((Object)userAndGroupConfig);
            return (LdapServerXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[50].callConstructor(LdapServerXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray)), LdapServerXO.class);
        }
        Object[] objectArray = new Object[62];
        objectArray[0] = "id";
        objectArray[1] = callSiteArray[88].callGetProperty((Object)ldapServer);
        objectArray[2] = "name";
        objectArray[3] = callSiteArray[89].callGetProperty((Object)ldapServer);
        objectArray[4] = "url";
        objectArray[5] = this.asLdapServerUrl(connectionInfo);
        objectArray[6] = "protocol";
        objectArray[7] = callSiteArray[90].call(callSiteArray[91].callGetProperty(callSiteArray[92].callGetProperty((Object)connectionInfo)));
        objectArray[8] = "useTrustStore";
        objectArray[9] = callSiteArray[93].callGetProperty((Object)connectionInfo);
        objectArray[10] = "host";
        objectArray[11] = callSiteArray[94].callGetProperty(callSiteArray[95].callGetProperty((Object)connectionInfo));
        objectArray[12] = "port";
        objectArray[13] = callSiteArray[96].callGetProperty(callSiteArray[97].callGetProperty((Object)connectionInfo));
        objectArray[14] = "searchBase";
        objectArray[15] = callSiteArray[98].callGetProperty((Object)connectionInfo);
        objectArray[16] = "authScheme";
        objectArray[17] = callSiteArray[99].callGetProperty((Object)connectionInfo);
        objectArray[18] = "authRealm";
        objectArray[19] = callSiteArray[100].callGetProperty((Object)connectionInfo);
        objectArray[20] = "authUsername";
        objectArray[21] = callSiteArray[101].callGetProperty((Object)connectionInfo);
        objectArray[22] = "connectionTimeout";
        objectArray[23] = callSiteArray[102].callGetProperty((Object)connectionInfo);
        objectArray[24] = "connectionRetryDelay";
        objectArray[25] = callSiteArray[103].callGetProperty((Object)connectionInfo);
        objectArray[26] = "maxIncidentsCount";
        objectArray[27] = callSiteArray[104].callGetProperty((Object)connectionInfo);
        objectArray[28] = "userBaseDn";
        objectArray[29] = callSiteArray[105].callGetProperty((Object)userAndGroupConfig);
        objectArray[30] = "userSubtree";
        objectArray[31] = callSiteArray[106].callGetProperty((Object)userAndGroupConfig);
        objectArray[32] = "userObjectClass";
        objectArray[33] = callSiteArray[107].callGetProperty((Object)userAndGroupConfig);
        objectArray[34] = "userLdapFilter";
        objectArray[35] = callSiteArray[108].callGetProperty((Object)userAndGroupConfig);
        objectArray[36] = "userIdAttribute";
        objectArray[37] = callSiteArray[109].callGetProperty((Object)userAndGroupConfig);
        objectArray[38] = "userRealNameAttribute";
        objectArray[39] = callSiteArray[110].callGetProperty((Object)userAndGroupConfig);
        objectArray[40] = "userEmailAddressAttribute";
        objectArray[41] = callSiteArray[111].callGetProperty((Object)userAndGroupConfig);
        objectArray[42] = "userPasswordAttribute";
        objectArray[43] = callSiteArray[112].callGetProperty((Object)userAndGroupConfig);
        objectArray[44] = "ldapGroupsAsRoles";
        objectArray[45] = callSiteArray[113].callGetProperty((Object)userAndGroupConfig);
        objectArray[46] = "groupType";
        objectArray[47] = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[114].callGetProperty((Object)userAndGroupConfig)) ? (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[115].callGetProperty((Object)userAndGroupConfig)) ? "dynamic" : "static") : null;
        objectArray[48] = "userMemberOfAttribute";
        objectArray[49] = callSiteArray[116].callGetProperty((Object)userAndGroupConfig);
        objectArray[50] = "groupBaseDn";
        objectArray[51] = callSiteArray[117].callGetProperty((Object)userAndGroupConfig);
        objectArray[52] = "groupSubtree";
        objectArray[53] = callSiteArray[118].callGetProperty((Object)userAndGroupConfig);
        objectArray[54] = "groupIdAttribute";
        objectArray[55] = callSiteArray[119].callGetProperty((Object)userAndGroupConfig);
        objectArray[56] = "groupMemberAttribute";
        objectArray[57] = callSiteArray[120].callGetProperty((Object)userAndGroupConfig);
        objectArray[58] = "groupMemberFormat";
        objectArray[59] = callSiteArray[121].callGetProperty((Object)userAndGroupConfig);
        objectArray[60] = "groupObjectClass";
        objectArray[61] = callSiteArray[122].callGetProperty((Object)userAndGroupConfig);
        return (LdapServerXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[87].callConstructor(LdapServerXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray)), LdapServerXO.class);
    }

    String asLdapServerUrl(Connection connectionInfo) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[123].call(callSiteArray[124].callConstructor(LdapURL.class, callSiteArray[125].call(callSiteArray[126].callGetProperty(callSiteArray[127].callGetProperty((Object)connectionInfo))), callSiteArray[128].callGetProperty(callSiteArray[129].callGetProperty((Object)connectionInfo)), callSiteArray[130].callGetProperty(callSiteArray[131].callGetProperty((Object)connectionInfo)), callSiteArray[132].callGetProperty((Object)connectionInfo))));
    }

    LdapSchemaTemplateXO asLdapSchemaTemplateXO(LdapSchemaTemplate template) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Mapping userAndGroupConfig = (Mapping)ScriptBytecodeAdapter.castToType((Object)callSiteArray[133].callGetProperty((Object)template), Mapping.class);
        Object[] objectArray = new Object[36];
        objectArray[0] = "name";
        objectArray[1] = callSiteArray[135].callGetProperty((Object)template);
        objectArray[2] = "userBaseDn";
        objectArray[3] = callSiteArray[136].callGetProperty((Object)userAndGroupConfig);
        objectArray[4] = "userSubtree";
        objectArray[5] = callSiteArray[137].callGetProperty((Object)userAndGroupConfig);
        objectArray[6] = "userObjectClass";
        objectArray[7] = callSiteArray[138].callGetProperty((Object)userAndGroupConfig);
        objectArray[8] = "userLdapFilter";
        objectArray[9] = callSiteArray[139].callGetProperty((Object)userAndGroupConfig);
        objectArray[10] = "userIdAttribute";
        objectArray[11] = callSiteArray[140].callGetProperty((Object)userAndGroupConfig);
        objectArray[12] = "userRealNameAttribute";
        objectArray[13] = callSiteArray[141].callGetProperty((Object)userAndGroupConfig);
        objectArray[14] = "userEmailAddressAttribute";
        objectArray[15] = callSiteArray[142].callGetProperty((Object)userAndGroupConfig);
        objectArray[16] = "userPasswordAttribute";
        objectArray[17] = callSiteArray[143].callGetProperty((Object)userAndGroupConfig);
        objectArray[18] = "ldapGroupsAsRoles";
        objectArray[19] = callSiteArray[144].callGetProperty((Object)userAndGroupConfig);
        objectArray[20] = "groupType";
        objectArray[21] = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[145].callGetProperty((Object)userAndGroupConfig)) ? (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[146].callGetProperty((Object)userAndGroupConfig)) ? "dynamic" : "static") : null;
        objectArray[22] = "userMemberOfAttribute";
        objectArray[23] = callSiteArray[147].callGetProperty((Object)userAndGroupConfig);
        objectArray[24] = "groupBaseDn";
        objectArray[25] = callSiteArray[148].callGetProperty((Object)userAndGroupConfig);
        objectArray[26] = "groupSubtree";
        objectArray[27] = callSiteArray[149].callGetProperty((Object)userAndGroupConfig);
        objectArray[28] = "groupIdAttribute";
        objectArray[29] = callSiteArray[150].callGetProperty((Object)userAndGroupConfig);
        objectArray[30] = "groupMemberAttribute";
        objectArray[31] = callSiteArray[151].callGetProperty((Object)userAndGroupConfig);
        objectArray[32] = "groupMemberFormat";
        objectArray[33] = callSiteArray[152].callGetProperty((Object)userAndGroupConfig);
        objectArray[34] = "groupObjectClass";
        objectArray[35] = callSiteArray[153].callGetProperty((Object)userAndGroupConfig);
        return (LdapSchemaTemplateXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[134].callConstructor(LdapSchemaTemplateXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray)), LdapSchemaTemplateXO.class);
    }

    LdapConfiguration asCLdapServerConfiguration(LdapServerXO ldapServerXO) {
        Object object;
        Reference ldapServerXO2 = new Reference((Object)ldapServerXO);
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Object mapping = callSiteArray[154].callConstructor(Mapping.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"userBaseDn", callSiteArray[155].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "userSubtree", DefaultTypeTransformation.booleanUnbox((Object)(object = callSiteArray[156].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())))) ? object : Boolean.valueOf(false), "userObjectClass", callSiteArray[157].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "ldapFilter", callSiteArray[158].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "userIdAttribute", callSiteArray[159].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "userRealNameAttribute", callSiteArray[160].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "emailAddressAttribute", callSiteArray[161].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "userPasswordAttribute", callSiteArray[162].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), "ldapGroupsAsRoles", callSiteArray[163].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get()))}));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[164].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())))) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[165].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), (Object)"dynamic")) {
                Object object2 = callSiteArray[166].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get()));
                ScriptBytecodeAdapter.setProperty((Object)object2, null, (Object)mapping, (String)"userMemberOfAttribute");
            } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[167].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())), (Object)"static")) {
                public class _asCLdapServerConfiguration_closure4
                extends Closure
                implements GeneratedClosure {
                    private /* synthetic */ Reference ldapServerXO;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;

                    public _asCLdapServerConfiguration_closure4(Object _outerInstance, Object _thisObject, Reference ldapServerXO) {
                        Reference reference;
                        CallSite[] callSiteArray = _asCLdapServerConfiguration_closure4.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.ldapServerXO = reference = ldapServerXO;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _asCLdapServerConfiguration_closure4.$getCallSiteArray();
                        Object object = callSiteArray[0].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupBaseDn");
                        Object object2 = callSiteArray[1].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        Object object3 = DefaultTypeTransformation.booleanUnbox((Object)object2) ? object2 : Boolean.valueOf(false);
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object3, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupSubtree");
                        Object object4 = callSiteArray[2].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object4, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupIdAttribute");
                        Object object5 = callSiteArray[3].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object5, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupMemberAttribute");
                        Object object6 = callSiteArray[4].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object6, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupMemberFormat");
                        Object object7 = callSiteArray[5].callGroovyObjectGetProperty(this.ldapServerXO.get());
                        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object7, _asCLdapServerConfiguration_closure4.class, (GroovyObject)this, (String)"groupObjectClass");
                        return object7;
                    }

                    public LdapServerXO getLdapServerXO() {
                        CallSite[] callSiteArray = _asCLdapServerConfiguration_closure4.$getCallSiteArray();
                        return (LdapServerXO)ScriptBytecodeAdapter.castToType((Object)this.ldapServerXO.get(), LdapServerXO.class);
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _asCLdapServerConfiguration_closure4.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _asCLdapServerConfiguration_closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "groupBaseDn";
                        stringArray[1] = "groupSubtree";
                        stringArray[2] = "groupIdAttribute";
                        stringArray[3] = "groupMemberAttribute";
                        stringArray[4] = "groupMemberFormat";
                        stringArray[5] = "groupObjectClass";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[6];
                        _asCLdapServerConfiguration_closure4.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_asCLdapServerConfiguration_closure4.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _asCLdapServerConfiguration_closure4.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }
                callSiteArray[168].call(mapping, (Object)new _asCLdapServerConfiguration_closure4((Object)this, (Object)this, ldapServerXO2));
            }
        }
        Object newConfig = callSiteArray[169].call((Object)this.ldapConfigurationManager);
        callSiteArray[170].call(newConfig, callSiteArray[171].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())));
        callSiteArray[172].call(newConfig, callSiteArray[173].callGroovyObjectGetProperty((Object)((LdapServerXO)ldapServerXO2.get())));
        callSiteArray[174].call(newConfig, callSiteArray[175].callCurrent((GroovyObject)this, (Object)((LdapServerXO)ldapServerXO2.get())));
        callSiteArray[176].call(newConfig, mapping);
        return (LdapConfiguration)ScriptBytecodeAdapter.castToType((Object)newConfig, LdapConfiguration.class);
    }

    Connection asConnection(LdapServerConnectionXO connectionXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        return (Connection)ScriptBytecodeAdapter.castToType((Object)callSiteArray[177].callConstructor(Connection.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"host", callSiteArray[178].callConstructor(Connection.Host.class, callSiteArray[179].call(Connection.Protocol.class, callSiteArray[180].call(callSiteArray[181].callGroovyObjectGetProperty((Object)connectionXO))), callSiteArray[182].callGroovyObjectGetProperty((Object)connectionXO), callSiteArray[183].callGroovyObjectGetProperty((Object)connectionXO)), "useTrustStore", callSiteArray[184].call(callSiteArray[185].callGetProperty(Boolean.class), callSiteArray[186].callGroovyObjectGetProperty((Object)connectionXO)), "searchBase", callSiteArray[187].callGroovyObjectGetProperty((Object)connectionXO), "authScheme", callSiteArray[188].callGroovyObjectGetProperty((Object)connectionXO), "saslRealm", callSiteArray[189].callGroovyObjectGetProperty((Object)connectionXO), "systemUsername", callSiteArray[190].callGroovyObjectGetProperty((Object)connectionXO), "systemPassword", callSiteArray[191].callGroovyObjectGetProperty((Object)connectionXO), "connectionTimeout", callSiteArray[192].callGroovyObjectGetProperty((Object)connectionXO), "connectionRetryDelay", callSiteArray[193].callGroovyObjectGetProperty((Object)connectionXO), "maxIncidentsCount", callSiteArray[194].callGroovyObjectGetProperty((Object)connectionXO)})), Connection.class);
    }

    LdapServerConnectionXO validate(LdapServerConnectionXO ldapServerConnectionXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[195].callGroovyObjectGetProperty((Object)ldapServerConnectionXO), (Object)"none")) {
            callSiteArray[196].call((Object)this.validator, (Object)ldapServerConnectionXO, LdapServerConnectionXO.AuthScheme.class);
        }
        return ldapServerConnectionXO;
    }

    LdapServerXO validate(LdapServerXO ldapServerXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        callSiteArray[197].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createGroovyObjectWrapper((GroovyObject)ldapServerXO, LdapServerConnectionXO.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[198].callGroovyObjectGetProperty((Object)ldapServerXO))) {
            callSiteArray[199].call((Object)this.validator, (Object)ldapServerXO, ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[200].callGroovyObjectGetProperty((Object)ldapServerXO), (Object)"static") ? LdapServerXO.GroupStatic.class : LdapServerXO.GroupDynamic.class);
        }
        return ldapServerXO;
    }

    private LdapContextFactory buildLdapContextFactory(LdapServerConnectionXO connectionXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        Object newConfig = callSiteArray[201].call((Object)this.ldapConfigurationManager);
        callSiteArray[202].call(newConfig, callSiteArray[203].callCurrent((GroovyObject)this, (Object)connectionXO));
        return (LdapContextFactory)ScriptBytecodeAdapter.castToType((Object)callSiteArray[204].call(LdapConnectionUtils.class, newConfig, (Object)this.trustStore), LdapContextFactory.class);
    }

    String buildReason(String userMessage, Throwable t) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        String message = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{userMessage, callSiteArray[205].callGetProperty((Object)t)}, new String[]{"", ": ", ""}));
        while (ScriptBytecodeAdapter.compareNotEqual((Object)t, (Object)callSiteArray[206].callGetProperty((Object)t)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[207].callGetProperty((Object)t))) {
            Object object = callSiteArray[208].callGetProperty((Object)t);
            t = (Throwable)ScriptBytecodeAdapter.castToType((Object)object, Throwable.class);
            message = ShortTypeHandling.castToString((Object)callSiteArray[209].call((Object)message, (Object)new GStringImpl(new Object[]{callSiteArray[210].callGetProperty(callSiteArray[211].call((Object)t)), callSiteArray[212].callGetProperty((Object)t)}, new String[]{" [Caused by ", ": ", "]"})));
        }
        return message;
    }

    String buildReason(LdapServerConnectionXO connectionXO) {
        CallSite[] callSiteArray = LdapServerComponent.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[213].callGroovyObjectGetProperty((Object)connectionXO), callSiteArray[214].callGroovyObjectGetProperty((Object)connectionXO)}, new String[]{"Failed to connect to LDAP Server. Please check the ", ":", " and authentication are correct."}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != LdapServerComponent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public LdapConfigurationManager getLdapConfigurationManager() {
        return this.ldapConfigurationManager;
    }

    public void setLdapConfigurationManager(LdapConfigurationManager ldapConfigurationManager) {
        this.ldapConfigurationManager = ldapConfigurationManager;
    }

    public LdapSchemaTemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(LdapSchemaTemplateManager ldapSchemaTemplateManager) {
        this.templateManager = ldapSchemaTemplateManager;
    }

    public LdapConnectionTester getLdapConnectionTester() {
        return this.ldapConnectionTester;
    }

    public void setLdapConnectionTester(LdapConnectionTester ldapConnectionTester) {
        this.ldapConnectionTester = ldapConnectionTester;
    }

    public EnterpriseLdapManager getLdapManager() {
        return this.ldapManager;
    }

    public void setLdapManager(EnterpriseLdapManager enterpriseLdapManager) {
        this.ldapManager = enterpriseLdapManager;
    }

    public TrustStore getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(TrustStore trustStore) {
        this.trustStore = trustStore;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "collect";
        stringArray[1] = "listLdapServerConfigurations";
        stringArray[2] = "collect";
        stringArray[3] = "listLdapServerConfigurations";
        stringArray[4] = "collect";
        stringArray[5] = "schemaTemplates";
        stringArray[6] = "addLdapServerConfiguration";
        stringArray[7] = "asCLdapServerConfiguration";
        stringArray[8] = "validate";
        stringArray[9] = "asLdapServerXO";
        stringArray[10] = "getLdapServerConfiguration";
        stringArray[11] = "getLdapServerConfiguration";
        stringArray[12] = "id";
        stringArray[13] = "updateLdapServerConfiguration";
        stringArray[14] = "asCLdapServerConfiguration";
        stringArray[15] = "validate";
        stringArray[16] = "asLdapServerXO";
        stringArray[17] = "getLdapServerConfiguration";
        stringArray[18] = "id";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "plus";
        stringArray[21] = "plus";
        stringArray[22] = "id";
        stringArray[23] = "deleteLdapServerConfiguration";
        stringArray[24] = "setServerOrder";
        stringArray[25] = "clearCache";
        stringArray[26] = "testConnection";
        stringArray[27] = "buildLdapContextFactory";
        stringArray[28] = "validate";
        stringArray[29] = "debug";
        stringArray[30] = "log";
        stringArray[31] = "getMessage";
        stringArray[32] = "<$constructor$>";
        stringArray[33] = "buildReason";
        stringArray[34] = "testUserAndGroupMapping";
        stringArray[35] = "buildLdapContextFactory";
        stringArray[36] = "validate";
        stringArray[37] = "getLdapAuthConfiguration";
        stringArray[38] = "asCLdapServerConfiguration";
        stringArray[39] = "<$constructor$>";
        stringArray[40] = "buildReason";
        stringArray[41] = "authenticateUserTest";
        stringArray[42] = "decodeBase64";
        stringArray[43] = "decodeBase64";
        stringArray[44] = "asCLdapServerConfiguration";
        stringArray[45] = "validate";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "buildReason";
        stringArray[48] = "connection";
        stringArray[49] = "mapping";
        stringArray[50] = "<$constructor$>";
        stringArray[51] = "id";
        stringArray[52] = "name";
        stringArray[53] = "asLdapServerUrl";
        stringArray[54] = "name";
        stringArray[55] = "protocol";
        stringArray[56] = "host";
        stringArray[57] = "useTrustStore";
        stringArray[58] = "hostName";
        stringArray[59] = "host";
        stringArray[60] = "port";
        stringArray[61] = "host";
        stringArray[62] = "searchBase";
        stringArray[63] = "authScheme";
        stringArray[64] = "saslRealm";
        stringArray[65] = "systemUsername";
        stringArray[66] = "connectionTimeout";
        stringArray[67] = "connectionRetryDelay";
        stringArray[68] = "maxIncidentsCount";
        stringArray[69] = "userBaseDn";
        stringArray[70] = "userSubtree";
        stringArray[71] = "userObjectClass";
        stringArray[72] = "ldapFilter";
        stringArray[73] = "userIdAttribute";
        stringArray[74] = "userRealNameAttribute";
        stringArray[75] = "emailAddressAttribute";
        stringArray[76] = "userPasswordAttribute";
        stringArray[77] = "ldapGroupsAsRoles";
        stringArray[78] = "ldapGroupsAsRoles";
        stringArray[79] = "userMemberOfAttribute";
        stringArray[80] = "userMemberOfAttribute";
        stringArray[81] = "groupBaseDn";
        stringArray[82] = "groupSubtree";
        stringArray[83] = "groupIdAttribute";
        stringArray[84] = "groupMemberAttribute";
        stringArray[85] = "groupMemberFormat";
        stringArray[86] = "groupObjectClass";
        stringArray[87] = "<$constructor$>";
        stringArray[88] = "id";
        stringArray[89] = "name";
        stringArray[90] = "name";
        stringArray[91] = "protocol";
        stringArray[92] = "host";
        stringArray[93] = "useTrustStore";
        stringArray[94] = "hostName";
        stringArray[95] = "host";
        stringArray[96] = "port";
        stringArray[97] = "host";
        stringArray[98] = "searchBase";
        stringArray[99] = "authScheme";
        stringArray[100] = "saslRealm";
        stringArray[101] = "systemUsername";
        stringArray[102] = "connectionTimeout";
        stringArray[103] = "connectionRetryDelay";
        stringArray[104] = "maxIncidentsCount";
        stringArray[105] = "userBaseDn";
        stringArray[106] = "userSubtree";
        stringArray[107] = "userObjectClass";
        stringArray[108] = "ldapFilter";
        stringArray[109] = "userIdAttribute";
        stringArray[110] = "userRealNameAttribute";
        stringArray[111] = "emailAddressAttribute";
        stringArray[112] = "userPasswordAttribute";
        stringArray[113] = "ldapGroupsAsRoles";
        stringArray[114] = "ldapGroupsAsRoles";
        stringArray[115] = "userMemberOfAttribute";
        stringArray[116] = "userMemberOfAttribute";
        stringArray[117] = "groupBaseDn";
        stringArray[118] = "groupSubtree";
        stringArray[119] = "groupIdAttribute";
        stringArray[120] = "groupMemberAttribute";
        stringArray[121] = "groupMemberFormat";
        stringArray[122] = "groupObjectClass";
        stringArray[123] = "toString";
        stringArray[124] = "<$constructor$>";
        stringArray[125] = "name";
        stringArray[126] = "protocol";
        stringArray[127] = "host";
        stringArray[128] = "hostName";
        stringArray[129] = "host";
        stringArray[130] = "port";
        stringArray[131] = "host";
        stringArray[132] = "searchBase";
        stringArray[133] = "userAndGroupAuthConfig";
        stringArray[134] = "<$constructor$>";
        stringArray[135] = "name";
        stringArray[136] = "userBaseDn";
        stringArray[137] = "userSubtree";
        stringArray[138] = "userObjectClass";
        stringArray[139] = "ldapFilter";
        stringArray[140] = "userIdAttribute";
        stringArray[141] = "userRealNameAttribute";
        stringArray[142] = "emailAddressAttribute";
        stringArray[143] = "userPasswordAttribute";
        stringArray[144] = "ldapGroupsAsRoles";
        stringArray[145] = "ldapGroupsAsRoles";
        stringArray[146] = "userMemberOfAttribute";
        stringArray[147] = "userMemberOfAttribute";
        stringArray[148] = "groupBaseDn";
        stringArray[149] = "groupSubtree";
        stringArray[150] = "groupIdAttribute";
        stringArray[151] = "groupMemberAttribute";
        stringArray[152] = "groupMemberFormat";
        stringArray[153] = "groupObjectClass";
        stringArray[154] = "<$constructor$>";
        stringArray[155] = "userBaseDn";
        stringArray[156] = "userSubtree";
        stringArray[157] = "userObjectClass";
        stringArray[158] = "userLdapFilter";
        stringArray[159] = "userIdAttribute";
        stringArray[160] = "userRealNameAttribute";
        stringArray[161] = "userEmailAddressAttribute";
        stringArray[162] = "userPasswordAttribute";
        stringArray[163] = "ldapGroupsAsRoles";
        stringArray[164] = "ldapGroupsAsRoles";
        stringArray[165] = "groupType";
        stringArray[166] = "userMemberOfAttribute";
        stringArray[167] = "groupType";
        stringArray[168] = "with";
        stringArray[169] = "newConfiguration";
        stringArray[170] = "setId";
        stringArray[171] = "id";
        stringArray[172] = "setName";
        stringArray[173] = "name";
        stringArray[174] = "setConnection";
        stringArray[175] = "asConnection";
        stringArray[176] = "setMapping";
        stringArray[177] = "<$constructor$>";
        stringArray[178] = "<$constructor$>";
        stringArray[179] = "valueOf";
        stringArray[180] = "name";
        stringArray[181] = "protocol";
        stringArray[182] = "host";
        stringArray[183] = "port";
        stringArray[184] = "equals";
        stringArray[185] = "TRUE";
        stringArray[186] = "useTrustStore";
        stringArray[187] = "searchBase";
        stringArray[188] = "authScheme";
        stringArray[189] = "authRealm";
        stringArray[190] = "authUsername";
        stringArray[191] = "authPassword";
        stringArray[192] = "connectionTimeout";
        stringArray[193] = "connectionRetryDelay";
        stringArray[194] = "maxIncidentsCount";
        stringArray[195] = "authScheme";
        stringArray[196] = "validate";
        stringArray[197] = "validate";
        stringArray[198] = "ldapGroupsAsRoles";
        stringArray[199] = "validate";
        stringArray[200] = "groupType";
        stringArray[201] = "newConfiguration";
        stringArray[202] = "setConnection";
        stringArray[203] = "asConnection";
        stringArray[204] = "getLdapContextFactory";
        stringArray[205] = "message";
        stringArray[206] = "cause";
        stringArray[207] = "cause";
        stringArray[208] = "cause";
        stringArray[209] = "plus";
        stringArray[210] = "name";
        stringArray[211] = "getClass";
        stringArray[212] = "message";
        stringArray[213] = "host";
        stringArray[214] = "port";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[215];
        LdapServerComponent.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LdapServerComponent.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LdapServerComponent.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

