/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.realms;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.cache.Cache;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.cache.CacheHelper;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.ldap.internal.CachedLdapUser;
import org.sonatype.nexus.ldap.internal.connector.DefaultLdapConnector;
import org.sonatype.nexus.ldap.internal.connector.FailoverLdapConnector;
import org.sonatype.nexus.ldap.internal.connector.LdapConnector;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapAuthConfiguration;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapDAOException;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapGroupDAO;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUser;
import org.sonatype.nexus.ldap.internal.connector.dao.LdapUserDAO;
import org.sonatype.nexus.ldap.internal.connector.dao.NoLdapUserRolesFoundException;
import org.sonatype.nexus.ldap.internal.connector.dao.NoSuchLdapGroupException;
import org.sonatype.nexus.ldap.internal.connector.dao.NoSuchLdapUserException;
import org.sonatype.nexus.ldap.internal.realms.LdapAuthenticator;
import org.sonatype.nexus.ldap.internal.realms.LdapConnectionUtils;
import org.sonatype.nexus.ldap.internal.realms.LdapManager;
import org.sonatype.nexus.ldap.persist.LdapCacheInvalidatedEvent;
import org.sonatype.nexus.ldap.persist.LdapConfigurationManager;
import org.sonatype.nexus.ldap.persist.LdapServerNotFoundException;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.ssl.TrustStore;

@Named
@Singleton
public class EnterpriseLdapManager
extends ComponentSupport
implements LdapManager,
EventAware {
    private static final String USER_CACHE_KEY = "enterprise-ldap";
    public static final String FAILED_TO_FIND_USER = "Failed to find user: ";
    public static final String FAILED_TO_GET_USERS_FROM_LDAP_SERVER = "Failed to get users from ldap server.";
    private final LdapAuthenticator ldapAuthenticator;
    private final LdapUserDAO ldapUserManager;
    private final LdapGroupDAO ldapGroupManager;
    private final LdapConfigurationManager ldapConfigurationManager;
    private final TrustStore trustStore;
    private final Provider<CacheHelper> cacheHelperProvider;
    private final Time userCacheTimeout;
    private volatile List<LdapConnector> ldapConnectors;

    @Inject
    public EnterpriseLdapManager(LdapAuthenticator ldapAuthenticator, LdapUserDAO ldapUserManager, LdapGroupDAO ldapGroupManager, LdapConfigurationManager ldapConfigurationManager, TrustStore trustStore, Provider<CacheHelper> cacheHelperProvider, @Named(value="${nexus.ldap.cache.user.timeToLive:-10m}") Time userCacheTimeout) {
        this.ldapAuthenticator = (LdapAuthenticator)Preconditions.checkNotNull((Object)ldapAuthenticator);
        this.ldapUserManager = (LdapUserDAO)Preconditions.checkNotNull((Object)ldapUserManager);
        this.ldapGroupManager = (LdapGroupDAO)Preconditions.checkNotNull((Object)ldapGroupManager);
        this.ldapConfigurationManager = (LdapConfigurationManager)Preconditions.checkNotNull((Object)ldapConfigurationManager);
        this.trustStore = (TrustStore)Preconditions.checkNotNull((Object)trustStore);
        this.cacheHelperProvider = (Provider)Preconditions.checkNotNull(cacheHelperProvider);
        this.userCacheTimeout = (Time)Preconditions.checkNotNull((Object)userCacheTimeout);
    }

    public LdapUser authenticateUserTest(String userId, String password, LdapConfiguration ldapServer) throws LdapServerNotFoundException, NoSuchLdapUserException {
        try {
            DefaultLdapConnector testLdapConnector = new DefaultLdapConnector(ldapServer.getId(), this.ldapUserManager, this.ldapGroupManager, LdapConnectionUtils.getLdapContextFactory(ldapServer, this.trustStore), this.getLdapAuthConfiguration(ldapServer));
            LdapUser user = testLdapConnector.getUser(userId);
            this.authenticateUser(user, password, testLdapConnector, ldapServer);
            return user;
        }
        catch (LdapDAOException e) {
            throw new AuthenticationException("Server: " + ldapServer.getName() + ", could not be accessed: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public LdapUser authenticateUser(String userId, String password) {
        LdapUser ldapUser = this.authenticateFromCache(userId, password);
        if (ldapUser != null) {
            return ldapUser;
        }
        try {
            for (LdapConnector connector : this.getLdapConnectors()) {
                try {
                    ldapUser = connector.getUser(userId);
                    this.authenticateUser(ldapUser, password, connector, this.ldapConfigurationManager.getLdapServerConfiguration(connector.getIdentifier()));
                    this.addUserToCache(userId, ldapUser, connector.getIdentifier(), password);
                    return ldapUser;
                }
                catch (IncorrectCredentialsException e) {
                    throw e;
                }
                catch (Exception e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug(FAILED_TO_FIND_USER + userId, (Throwable)e);
                }
            }
        }
        catch (LdapDAOException e) {
            throw new AuthenticationException("User: " + userId + " could not be authenticated.", (Throwable)e);
        }
        throw new AuthenticationException("User: " + userId + " could not be authenticated.");
    }

    @Override
    public SortedSet<String> getAllGroups() throws LdapDAOException {
        TreeSet<String> groupIds = new TreeSet<String>();
        for (LdapConnector connector : this.getLdapConnectors()) {
            try {
                groupIds.addAll(connector.getAllGroups());
            }
            catch (LdapDAOException e) {
                this.log.debug("Failed to get groups from ldap server.", (Throwable)e);
            }
        }
        return groupIds;
    }

    @Override
    public SortedSet<LdapUser> getAllUsers() throws LdapDAOException {
        TreeSet<LdapUser> users = new TreeSet<LdapUser>();
        for (LdapConnector connector : this.getLdapConnectors()) {
            try {
                users.addAll(connector.getAllUsers());
            }
            catch (LdapDAOException e) {
                this.log.debug(FAILED_TO_GET_USERS_FROM_LDAP_SERVER, (Throwable)e);
            }
        }
        return users;
    }

    @Override
    public String getGroupName(String groupId) throws LdapDAOException, NoSuchLdapGroupException {
        for (LdapConnector connector : this.getLdapConnectors()) {
            try {
                return connector.getGroupName(groupId);
            }
            catch (NoSuchLdapGroupException e) {
                this.log.debug("Failed to find group: " + groupId, (Throwable)e);
            }
            catch (LdapDAOException e) {
                this.log.debug("Failed to find group: " + groupId, (Throwable)e);
            }
        }
        throw new NoSuchLdapGroupException(groupId, groupId);
    }

    @Override
    public LdapUser getUser(String userId) throws NoSuchLdapUserException, LdapDAOException {
        LdapUser ldapUser = this.getUserFromCache(userId);
        if (ldapUser != null) {
            return ldapUser;
        }
        LdapDAOException serverError = null;
        for (LdapConnector connector : this.getLdapConnectors()) {
            try {
                ldapUser = connector.getUser(userId);
                this.addUserToCache(userId, ldapUser, connector.getIdentifier(), null);
                return ldapUser;
            }
            catch (NoSuchLdapUserException e) {
                this.log.debug(FAILED_TO_FIND_USER + userId, (Throwable)e);
            }
            catch (LdapDAOException e) {
                this.log.debug(FAILED_TO_FIND_USER + userId, (Throwable)e);
                serverError = e;
            }
        }
        if (serverError == null) {
            throw new NoSuchLdapUserException(userId);
        }
        throw new LdapDAOException(FAILED_TO_FIND_USER + userId + ", we could not connect to all servers.", serverError);
    }

    @Override
    public Set<String> getUserRoles(String userId) throws LdapDAOException, NoLdapUserRolesFoundException {
        try {
            LdapUser ldapUser = this.getUser(userId);
            return ldapUser.getMembership();
        }
        catch (LdapDAOException e) {
            this.log.debug(FAILED_TO_FIND_USER + userId, (Throwable)e);
        }
        catch (NoSuchLdapUserException e) {
            this.log.debug(FAILED_TO_FIND_USER + userId, (Throwable)e);
        }
        throw new NoLdapUserRolesFoundException(userId);
    }

    @Override
    public SortedSet<LdapUser> getUsers(int userCount) throws LdapDAOException {
        if (userCount < 0) {
            return this.getAllUsers();
        }
        TreeSet<LdapUser> users = new TreeSet<LdapUser>();
        for (LdapConnector connector : this.getLdapConnectors()) {
            try {
                if (userCount - users.size() <= 0) break;
                users.addAll(connector.getUsers(userCount - users.size()));
            }
            catch (LdapDAOException e) {
                this.log.debug(FAILED_TO_GET_USERS_FROM_LDAP_SERVER, (Throwable)e);
            }
        }
        return users;
    }

    @Override
    public SortedSet<LdapUser> searchUsers(String username, Set<String> roleIds) throws LdapDAOException {
        return this.searchUsers(username, roleIds, -1);
    }

    @Override
    public SortedSet<LdapUser> searchUsers(String username, Set<String> roleIds, int userCount) throws LdapDAOException {
        TreeSet<LdapUser> users = new TreeSet<LdapUser>();
        for (LdapConnector connector : this.getLdapConnectors()) {
            try {
                users.addAll(connector.searchUsers(username, roleIds, userCount));
            }
            catch (LdapDAOException e) {
                this.log.debug(FAILED_TO_GET_USERS_FROM_LDAP_SERVER, (Throwable)e);
            }
        }
        return users;
    }

    @VisibleForTesting
    List<LdapConnector> getLdapConnectors() throws LdapDAOException {
        ImmutableList localCopy = this.ldapConnectors;
        if (localCopy == null) {
            ArrayList<FailoverLdapConnector> newList = new ArrayList<FailoverLdapConnector>();
            for (LdapConfiguration ldapServer : this.ldapConfigurationManager.listLdapServerConfigurations()) {
                DefaultLdapConnector originalLdapConnector = new DefaultLdapConnector(ldapServer.getId(), this.ldapUserManager, this.ldapGroupManager, LdapConnectionUtils.getLdapContextFactory(ldapServer, this.trustStore), this.getLdapAuthConfiguration(ldapServer));
                newList.add(new FailoverLdapConnector(originalLdapConnector, null, ldapServer.getConnection().getConnectionRetryDelay(), ldapServer.getConnection().getMaxIncidentsCount()));
            }
            this.ldapConnectors = localCopy = ImmutableList.copyOf(newList);
        }
        return localCopy;
    }

    @VisibleForTesting
    void setLdapConnectors(List<LdapConnector> ldapConnectors) {
        this.ldapConnectors = ImmutableList.copyOf(ldapConnectors);
    }

    private LdapAuthConfiguration getLdapAuthConfiguration(LdapConfiguration ldapServer) {
        return LdapConnectionUtils.getLdapAuthConfiguration(ldapServer);
    }

    private void authenticateUser(LdapUser ldapUser, String password, LdapConnector ldapConnector, LdapConfiguration ldapServer) throws LdapServerNotFoundException, LdapDAOException {
        if (Strings2.isEmpty((String)ldapServer.getMapping().getUserPasswordAttribute())) {
            this.log.debug("Checking auth with bind for ldap user: {}", (Object)ldapUser.getUsername());
            this.ldapAuthenticator.authenticateUserWithBind(ldapUser, password, ldapConnector.getLdapContextFactory(), ldapServer.getConnection().getAuthScheme());
        } else {
            this.log.debug("Checking auth with attribute for ldap user: {}", (Object)ldapUser.getUsername());
            this.ldapAuthenticator.authenticateUserWithPassword(ldapUser, password);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void on(LdapCacheInvalidatedEvent event) {
        this.ldapConnectors = null;
        this.clearUserCache();
    }

    private void clearUserCache() {
        this.getUserCache().clear();
        this.log.debug("Ldap User cache cleared.");
    }

    private Cache<String, CachedLdapUser> getUserCache() {
        return this.maybeCreateCache();
    }

    private void addUserToCache(String userId, LdapUser ldapUser, String ldapServerId, String password) {
        CachedLdapUser cachedLdapUser = new CachedLdapUser(ldapUser, password);
        long cacheTimeout = this.userCacheTimeout.toMillis();
        if (cacheTimeout > 0L) {
            this.getUserCache().put((Object)userId, (Object)cachedLdapUser);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Adding Ldap User: {} to cache, from server: {}, item should be valid until: {}", new Object[]{ldapUser.getUsername(), ldapServerId, new Date(System.currentTimeMillis() + cacheTimeout)});
            }
        }
    }

    private LdapUser getUserFromCache(String userId) {
        return Optional.ofNullable(this.getCachedUserFromCache(userId)).map(CachedLdapUser::getLdapUser).orElse(null);
    }

    private CachedLdapUser getCachedUserFromCache(String userId) {
        CachedLdapUser cachedUser = (CachedLdapUser)this.getUserCache().get((Object)userId);
        if (cachedUser == null) {
            this.log.debug("Ldap User: {} not found in cache.", (Object)userId);
        } else {
            this.log.debug("Ldap User: {} found in cache.", (Object)userId);
        }
        return cachedUser;
    }

    private LdapUser authenticateFromCache(String userId, String password) {
        try {
            CachedLdapUser cachedLdapUser = this.getCachedUserFromCache(userId);
            if (cachedLdapUser != null) {
                LdapUser ldapUser = cachedLdapUser.getLdapUser();
                if (password.equals(cachedLdapUser.getPassword())) {
                    return ldapUser;
                }
            }
        }
        catch (Exception e) {
            this.log.debug("User: {} was found in cache but failed to be authenticated.", (Object)userId, (Object)e);
        }
        return null;
    }

    private <K, V> Cache<K, V> maybeCreateCache() {
        return ((CacheHelper)this.cacheHelperProvider.get()).maybeCreateCache(USER_CACHE_KEY, this.createCacheConfig());
    }

    private <K, V> MutableConfiguration<K, V> createCacheConfig() {
        return new MutableConfiguration().setStoreByValue(false).setExpiryPolicyFactory(CreatedExpiryPolicy.factoryOf((Duration)new Duration(this.userCacheTimeout.getUnit(), this.userCacheTimeout.getValue()))).setManagementEnabled(true).setStatisticsEnabled(true);
    }
}

