/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.internal.connector.dao.password;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.codec.Base64;
import org.sonatype.nexus.crypto.RandomBytesGenerator;
import org.sonatype.nexus.ldap.internal.connector.dao.password.PasswordEncoder;

@Singleton
@Named(value="ssha")
public class SSHAPasswordEncoder
implements PasswordEncoder {
    private static final String SSHA_PREFIX = "{SSHA}";
    private final RandomBytesGenerator randomBytesGenerator;

    @Inject
    public SSHAPasswordEncoder(RandomBytesGenerator randomBytesGenerator) {
        this.randomBytesGenerator = (RandomBytesGenerator)Preconditions.checkNotNull((Object)randomBytesGenerator);
    }

    @Override
    public String getMethod() {
        return "SSHA";
    }

    @Override
    public String encodePassword(String password, Object salt) {
        try {
            MessageDigest md;
            byte[] saltBytes = null;
            if (salt == null) {
                saltBytes = new BigInteger(this.randomBytesGenerator.generate(4)).toString(32).getBytes("UTF-8");
            } else if (byte[].class.isInstance(salt)) {
                saltBytes = (byte[])salt;
            } else {
                throw new IllegalArgumentException("salt must be of type: byte[].");
            }
            try {
                md = MessageDigest.getInstance("SHA1");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Digest SHA not supported on this JVM.");
            }
            md.update(password.getBytes("UTF-8"));
            md.update(saltBytes);
            byte[] digested = md.digest();
            byte[] toBeEncoded = new byte[digested.length + saltBytes.length];
            System.arraycopy(digested, 0, toBeEncoded, 0, digested.length);
            System.arraycopy(saltBytes, 0, toBeEncoded, digested.length, saltBytes.length);
            return SSHA_PREFIX + Base64.encodeToString((byte[])toBeEncoded);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This JVM failed to get bytes in UTF-8 from String: " + salt, e);
        }
    }

    @Override
    public boolean isPasswordValid(String encPassword, String inputPassword, Object salt) {
        byte[] decodedBytes;
        String encryptedPassword;
        block5: {
            if (inputPassword == null) {
                return false;
            }
            encryptedPassword = encPassword;
            if (encryptedPassword.startsWith(SSHA_PREFIX) || encryptedPassword.startsWith(SSHA_PREFIX.toLowerCase())) {
                encryptedPassword = encryptedPassword.substring(SSHA_PREFIX.length());
            }
            try {
                decodedBytes = Base64.decode((byte[])encryptedPassword.getBytes("UTF-8"));
                if (decodedBytes.length - 20 > 0) break block5;
                return false;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("This JVM failed to get bytes in UTF-8 from String: " + salt, e);
            }
        }
        byte[] decryptSalt = new byte[decodedBytes.length - 20];
        System.arraycopy(decodedBytes, 20, decryptSalt, 0, decryptSalt.length);
        String check = this.encodePassword(inputPassword, decryptSalt);
        return check.substring(SSHA_PREFIX.length()).equals(encryptedPassword);
    }
}

