/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ldap.api;

import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.Validator;
import javax.validation.constraints.NotNull;
import javax.validation.groups.Default;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.ldap.LdapApiUtils;
import org.sonatype.nexus.ldap.api.LdapApiResourceDoc;
import org.sonatype.nexus.ldap.model.CreateLdapServerXo;
import org.sonatype.nexus.ldap.model.ReadLdapServerXo;
import org.sonatype.nexus.ldap.model.UpdateLdapServerXo;
import org.sonatype.nexus.ldap.persist.LdapConfigurationManager;
import org.sonatype.nexus.ldap.persist.LdapServerNotFoundException;
import org.sonatype.nexus.ldap.persist.entity.LdapConfiguration;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;
import org.sonatype.nexus.validation.group.Create;
import org.sonatype.nexus.validation.group.Update;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LdapApiResource
extends ComponentSupport
implements Resource,
LdapApiResourceDoc {
    private static final String NOT_FOUND_MESSAGE = "LDAP server named '%s' was not found";
    private LdapConfigurationManager ldapConfigurationManager;
    private Validator validator;

    @Inject
    public LdapApiResource(LdapConfigurationManager ldapConfigurationManager, Validator validator) {
        this.ldapConfigurationManager = (LdapConfigurationManager)Preconditions.checkNotNull((Object)ldapConfigurationManager);
        this.validator = (Validator)Preconditions.checkNotNull((Object)validator);
    }

    @Override
    @GET
    @RequiresPermissions(value={"nexus:ldap:read"})
    public List<ReadLdapServerXo> getLdapServers() {
        LinkedList<ReadLdapServerXo> servers = new LinkedList<ReadLdapServerXo>();
        int i = 1;
        for (LdapConfiguration ldapConfiguration : this.ldapConfigurationManager.listLdapServerConfigurations()) {
            ReadLdapServerXo ldapServerXo = LdapApiUtils.asLdapServerXO(ReadLdapServerXo.class, ldapConfiguration);
            ldapServerXo.setOrder(i++);
            servers.add(ldapServerXo);
        }
        return servers;
    }

    @Override
    @GET
    @Path(value="/{name}")
    @RequiresPermissions(value={"nexus:ldap:read"})
    public ReadLdapServerXo getLdapServer(@PathParam(value="name") String name) {
        try {
            return LdapApiUtils.asLdapServerXO(ReadLdapServerXo.class, this.ldapConfigurationManager.getLdapServerConfigurationByName(name));
        }
        catch (LdapServerNotFoundException e) {
            String message = String.format(NOT_FOUND_MESSAGE, name);
            this.log.debug(message, (Throwable)e);
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)("\"" + message + "\""), "application/json");
        }
    }

    @Override
    @DELETE
    @Path(value="/{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:delete"})
    public void deleteLdapServer(@PathParam(value="name") String name) {
        try {
            this.ldapConfigurationManager.deleteLdapServerConfigurationByName(name);
        }
        catch (LdapServerNotFoundException e) {
            String message = String.format(NOT_FOUND_MESSAGE, name);
            this.log.debug(message, (Throwable)e);
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)("\"" + message + "\""), "application/json");
        }
    }

    @Override
    @POST
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:create"})
    @Validate(groups={Create.class, Default.class})
    public Response createLdapServer(@NotNull @Valid CreateLdapServerXo ldapServerXo) {
        LdapApiUtils.validateLdapServerXo(this.validator, ldapServerXo, this.log);
        LdapConfiguration ldapConfiguration = ldapServerXo.toLdapConfiguration(this.ldapConfigurationManager.newConfiguration());
        try {
            this.ldapConfigurationManager.addLdapServerConfiguration(ldapConfiguration);
        }
        catch (Exception e) {
            this.log.debug("Failed to create a new LDAP server", (Throwable)e);
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)("\"" + e.getMessage() + "\""), "application/json");
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @Override
    @PUT
    @Path(value="/{name}")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    @Validate(groups={Update.class, Default.class})
    public void updateLdapServer(@PathParam(value="name") String name, @NotNull @Valid UpdateLdapServerXo ldapServerXo) {
        LdapApiUtils.validateLdapServerXo(this.validator, ldapServerXo, this.log);
        try {
            this.ldapConfigurationManager.updateLdapServerConfiguration(ldapServerXo.toLdapConfiguration(this.ldapConfigurationManager.newConfiguration()));
        }
        catch (LdapServerNotFoundException e) {
            String message = String.format(NOT_FOUND_MESSAGE, name);
            this.log.debug(message, (Throwable)e);
            throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)("\"" + message + "\""), "application/json");
        }
    }

    @Override
    @POST
    @Path(value="/change-order")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:ldap:update"})
    public void changeOrder(@NotNull List<String> orderedLdapServerNames) {
        List<String> orderedLdapServerIds = orderedLdapServerNames.stream().map(name -> {
            try {
                return this.ldapConfigurationManager.getLdapServerConfigurationByName((String)name);
            }
            catch (LdapServerNotFoundException e) {
                String message = String.format(NOT_FOUND_MESSAGE, name);
                this.log.debug(message, (Throwable)e);
                throw new WebApplicationMessageException(Response.Status.NOT_FOUND, (Object)("\"" + message + "\""), "application/json");
            }
        }).map(LdapConfiguration::getId).collect(Collectors.toList());
        this.ldapConfigurationManager.setServerOrder(orderedLdapServerIds);
    }
}

