/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.rest;

import com.google.common.base.Preconditions;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.api.BlobStoreMetrics;
import org.sonatype.nexus.blobstore.rest.BlobStoreApiModel;

public class GenericBlobStoreApiResponse
extends BlobStoreApiModel {
    private String name;
    private String type;
    private boolean unavailable;
    private long blobCount;
    private long totalSizeInBytes;
    private long availableSpaceInBytes;

    public GenericBlobStoreApiResponse() {
    }

    public GenericBlobStoreApiResponse(BlobStore blobStore) {
        super(blobStore.getBlobStoreConfiguration());
        BlobStoreConfiguration configuration = blobStore.getBlobStoreConfiguration();
        if (blobStore.isStarted()) {
            BlobStoreMetrics metrics = blobStore.getMetrics();
            this.unavailable = metrics.isUnavailable();
            this.blobCount = metrics.getBlobCount();
            this.totalSizeInBytes = metrics.getTotalSize();
            this.availableSpaceInBytes = metrics.getAvailableSpace();
        }
        this.name = (String)Preconditions.checkNotNull((Object)configuration.getName());
        this.setType((String)Preconditions.checkNotNull((Object)configuration.getType()));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isUnavailable() {
        return this.unavailable;
    }

    public void setUnavailable(boolean unavailable) {
        this.unavailable = unavailable;
    }

    public long getBlobCount() {
        return this.blobCount;
    }

    public void setBlobCount(long blobCount) {
        this.blobCount = blobCount;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public void setTotalSizeInBytes(long totalSizeInBytes) {
        this.totalSizeInBytes = totalSizeInBytes;
    }

    public long getAvailableSpaceInBytes() {
        return this.availableSpaceInBytes;
    }

    public void setAvailableSpaceInBytes(long availableSpaceInBytes) {
        this.availableSpaceInBytes = availableSpaceInBytes;
    }
}

