/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.rest;

import io.swagger.annotations.ApiModelProperty;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuotaSupport;
import org.sonatype.nexus.blobstore.rest.BlobStoreApiSoftQuota;

public abstract class BlobStoreApiModel {
    @ApiModelProperty(value="Settings to control the soft quota")
    private BlobStoreApiSoftQuota softQuota;

    public BlobStoreApiModel() {
    }

    public BlobStoreApiModel(BlobStoreConfiguration configuration) {
        this.softQuota = this.createSoftQuota(configuration);
    }

    public BlobStoreApiSoftQuota getSoftQuota() {
        return this.softQuota;
    }

    public void setSoftQuota(BlobStoreApiSoftQuota softQuota) {
        this.softQuota = softQuota;
    }

    public BlobStoreConfiguration toBlobStoreConfiguration(BlobStoreConfiguration configuration) {
        this.setSoftQuotaAttributes(configuration);
        return configuration;
    }

    private void setSoftQuotaAttributes(BlobStoreConfiguration configuration) {
        if (this.softQuota == null) {
            return;
        }
        configuration.attributes("blobStoreQuotaConfig").set("quotaType", (Object)this.softQuota.getType());
        if (this.softQuota.getLimit() == null) {
            configuration.attributes("blobStoreQuotaConfig").set("quotaLimitBytes", (Object)-1L);
        } else {
            configuration.attributes("blobStoreQuotaConfig").set("quotaLimitBytes", (Object)this.softQuota.getLimit());
        }
    }

    private BlobStoreApiSoftQuota createSoftQuota(BlobStoreConfiguration configuration) {
        if (configuration.attributes("blobStoreQuotaConfig").isEmpty()) {
            return null;
        }
        BlobStoreApiSoftQuota newSoftQuota = new BlobStoreApiSoftQuota();
        newSoftQuota.setType(BlobStoreQuotaSupport.getType(configuration));
        newSoftQuota.setLimit(BlobStoreQuotaSupport.getLimit(configuration));
        return newSoftQuota;
    }
}

