/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.metrics;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.OperationMetrics;
import org.sonatype.nexus.blobstore.api.OperationType;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsEntity;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsService;
import org.sonatype.nexus.blobstore.api.metrics.BlobStoreMetricsStore;
import org.sonatype.nexus.blobstore.api.metrics.DatastoreBlobStoreMetricsContainer;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.scheduling.PeriodicJobService;

public abstract class DatastoreBlobStoreMetricsServiceSupport
extends StateGuardLifecycleSupport
implements BlobStoreMetricsService {
    private final int metricsFlushPeriodSeconds;
    private final PeriodicJobService jobService;
    private final DatastoreBlobStoreMetricsContainer datastoreBlobStoreMetricsContainer;
    private PeriodicJobService.PeriodicJob metricsWritingJob;
    protected final BlobStoreMetricsStore blobStoreMetricsStore;
    protected BlobStore blobStore;

    protected DatastoreBlobStoreMetricsServiceSupport(int metricsFlushPeriodSeconds, PeriodicJobService jobService, BlobStoreMetricsStore blobStoreMetricsStore) {
        this.metricsFlushPeriodSeconds = metricsFlushPeriodSeconds;
        this.jobService = (PeriodicJobService)Preconditions.checkNotNull((Object)jobService);
        this.blobStoreMetricsStore = (BlobStoreMetricsStore)Preconditions.checkNotNull((Object)blobStoreMetricsStore);
        this.datastoreBlobStoreMetricsContainer = new DatastoreBlobStoreMetricsContainer();
    }

    protected void doStart() throws Exception {
        this.blobStoreMetricsStore.initializeMetrics(this.blobStore.getBlobStoreConfiguration().getName());
        this.jobService.startUsing();
        this.metricsWritingJob = this.jobService.schedule(() -> {
            if (this.datastoreBlobStoreMetricsContainer.metricsNeedFlushing()) {
                try {
                    this.flush();
                }
                catch (Exception e) {
                    this.log.error("Failed to save blobstore metrics to db", (Throwable)e);
                }
            }
        }, this.metricsFlushPeriodSeconds);
    }

    public void stop() throws Exception {
        this.metricsWritingJob.cancel();
        this.metricsWritingJob = null;
        this.jobService.stopUsing();
    }

    public void setBlobStore(BlobStore blobStore) {
        this.blobStore = blobStore;
    }

    public void recordAddition(long size) {
        this.datastoreBlobStoreMetricsContainer.recordAddition(size);
    }

    public void recordDeletion(long size) {
        this.datastoreBlobStoreMetricsContainer.recordDeletion(size);
    }

    public Map<OperationType, OperationMetrics> getOperationMetrics() {
        BlobStoreMetricsEntity metricsEntity = this.blobStoreMetricsStore.get(this.blobStore.getBlobStoreConfiguration().getName());
        Map<OperationType, OperationMetrics> delta = this.getOperationMetricsDelta();
        OperationMetrics uploadMetrics = new OperationMetrics();
        uploadMetrics.setBlobSize(metricsEntity.getUploadBlobSize());
        uploadMetrics.setErrorRequests(metricsEntity.getUploadErrorRequests());
        uploadMetrics.setSuccessfulRequests(metricsEntity.getUploadSuccessfulRequests());
        uploadMetrics.setTimeOnRequests(metricsEntity.getUploadTimeOnRequests());
        uploadMetrics.add(delta.get(OperationType.UPLOAD));
        OperationMetrics downloadMetrics = new OperationMetrics();
        downloadMetrics.setBlobSize(metricsEntity.getDownloadBlobSize());
        downloadMetrics.setErrorRequests(metricsEntity.getDownloadErrorRequests());
        downloadMetrics.setSuccessfulRequests(metricsEntity.getDownloadSuccessfulRequests());
        downloadMetrics.setTimeOnRequests(metricsEntity.getDownloadTimeOnRequests());
        downloadMetrics.add(delta.get(OperationType.DOWNLOAD));
        HashMap<OperationType, OperationMetrics> operationMetricsMap = new HashMap<OperationType, OperationMetrics>();
        operationMetricsMap.put(OperationType.UPLOAD, uploadMetrics);
        operationMetricsMap.put(OperationType.DOWNLOAD, downloadMetrics);
        return Collections.unmodifiableMap(operationMetricsMap);
    }

    public Map<OperationType, OperationMetrics> getOperationMetricsDelta() {
        return this.datastoreBlobStoreMetricsContainer.getOperationMetricsDelta();
    }

    public void flush() throws IOException {
        OperationMetrics uploadMetrics = (OperationMetrics)this.datastoreBlobStoreMetricsContainer.getOperationMetricsDelta().get(OperationType.UPLOAD);
        OperationMetrics downloadMetrics = (OperationMetrics)this.datastoreBlobStoreMetricsContainer.getOperationMetricsDelta().get(OperationType.DOWNLOAD);
        BlobStoreMetricsEntity blobStoreMetricsEntity = new BlobStoreMetricsEntity().setBlobStoreName(this.blobStore.getBlobStoreConfiguration().getName()).setBlobCount(this.datastoreBlobStoreMetricsContainer.blobCountDelta.getAndSet(0L)).setTotalSize(this.datastoreBlobStoreMetricsContainer.blobstoreUsageDelta.getAndSet(0L)).setDownloadBlobSize(downloadMetrics.getBlobSize()).setDownloadErrorRequests(downloadMetrics.getErrorRequests()).setDownloadSuccessfulRequests(downloadMetrics.getSuccessfulRequests()).setDownloadTimeOnRequests(downloadMetrics.getTimeOnRequests()).setUploadBlobSize(uploadMetrics.getBlobSize()).setUploadErrorRequests(uploadMetrics.getErrorRequests()).setUploadSuccessfulRequests(uploadMetrics.getSuccessfulRequests()).setDownloadTimeOnRequests(uploadMetrics.getTimeOnRequests());
        uploadMetrics.clear();
        downloadMetrics.clear();
        this.blobStoreMetricsStore.updateMetrics(blobStoreMetricsEntity);
    }

    public void clearOperationMetrics() {
        this.datastoreBlobStoreMetricsContainer.getOperationMetricsDelta().values().forEach(OperationMetrics::clear);
        this.blobStoreMetricsStore.clearOperationMetrics(this.blobStore.getBlobStoreConfiguration().getName());
    }

    public void remove() {
        this.blobStoreMetricsStore.remove(this.blobStore.getBlobStoreConfiguration().getName());
    }
}

