/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.metrics;

import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.sonatype.nexus.blobstore.metrics.BlobStoreAnalyticsInterceptor;
import org.sonatype.nexus.blobstore.metrics.MonitoringBlobStoreMetrics;
import org.sonatype.nexus.common.guice.AbstractInterceptorModule;

public class BlobStoreModule
extends AbstractInterceptorModule {
    protected void configure() {
        this.bindInterceptor(Matchers.any(), (Matcher)new TransactionalMatcher(), new MethodInterceptor[]{new BlobStoreAnalyticsInterceptor()});
    }

    private static final class TransactionalMatcher
    extends AbstractMatcher<Method> {
        private TransactionalMatcher() {
        }

        public boolean matches(Method method) {
            if (method.isAnnotationPresent(MonitoringBlobStoreMetrics.class)) {
                return true;
            }
            Annotation[] annotationArray = method.getDeclaredAnnotations();
            int n = annotationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.annotationType().isAnnotationPresent(MonitoringBlobStoreMetrics.class)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

