/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.group.internal;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import javax.inject.Named;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.group.BlobStoreGroup;
import org.sonatype.nexus.blobstore.group.FillPolicy;

@Named(value="roundRobin")
public class RoundRobinFillPolicy
extends ComponentSupport
implements FillPolicy {
    public static final String TYPE = "roundRobin";
    protected static final String NAME = "Round Robin";
    private AtomicInteger sequence = new AtomicInteger();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @Nullable
    public BlobStore chooseBlobStore(BlobStoreGroup blobStoreGroup, Map<String, String> headers) {
        return this.nextMember(blobStoreGroup.getMembers());
    }

    @Nullable
    private BlobStore nextMember(List<BlobStore> members) {
        if (members.isEmpty()) {
            return null;
        }
        int index = this.nextIndex() % members.size();
        this.log.trace("Using index {}", (Object)index);
        ArrayList<BlobStore> rotatedMembers = new ArrayList<BlobStore>(members);
        Collections.rotate(rotatedMembers, index);
        return rotatedMembers.stream().filter(BlobStore::isWritable).filter(BlobStore::isStorageAvailable).findFirst().orElse(null);
    }

    @VisibleForTesting
    int nextIndex() {
        return this.sequence.getAndUpdate(i -> ++i < 0 ? 0 : i);
    }
}

