/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.io.CountingInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.sonatype.nexus.blobstore.PerformanceLogger;

public class PerformanceLoggingInputStream
extends FilterInputStream {
    private final PerformanceLogger performanceLogger;
    private final CountingInputStream countingInputStream;
    private long totalNanosElapsed;

    public PerformanceLoggingInputStream(InputStream source, PerformanceLogger performanceLogger) {
        this(new CountingInputStream(source), performanceLogger);
    }

    private PerformanceLoggingInputStream(CountingInputStream countingInputStream, PerformanceLogger performanceLogger) {
        super((InputStream)countingInputStream);
        this.countingInputStream = (CountingInputStream)Preconditions.checkNotNull((Object)countingInputStream);
        this.performanceLogger = (PerformanceLogger)Preconditions.checkNotNull((Object)performanceLogger);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.performanceLogger.logRead(this.countingInputStream.getCount(), this.totalNanosElapsed);
    }

    @Override
    public int read() throws IOException {
        long start = System.nanoTime();
        int val = this.in.read();
        this.totalNanosElapsed += System.nanoTime() - start;
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        long start = System.nanoTime();
        int bytesRead = this.in.read(b);
        this.totalNanosElapsed += System.nanoTime() - start;
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        long start = System.nanoTime();
        int bytesRead = this.in.read(b, off, len);
        this.totalNanosElapsed += System.nanoTime() - start;
        return bytesRead;
    }
}

