/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.blobstore.api.BlobSession;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.transaction.Transaction;
import org.sonatype.nexus.transaction.TransactionSupport;

public class MemoryBlobSession
extends TransactionSupport
implements BlobSession<Transaction> {
    private static final Logger log = LoggerFactory.getLogger(MemoryBlobSession.class);
    private final BlobStore blobStore;
    private final Set<BlobId> creates = new HashSet<BlobId>();
    private final Set<BlobId> deletes = new HashSet<BlobId>();

    public MemoryBlobSession(BlobStore blobStore) {
        this.blobStore = (BlobStore)Preconditions.checkNotNull((Object)blobStore);
    }

    public Transaction getTransaction() {
        return this;
    }

    public Blob create(InputStream blobData, Map<String, String> headers, BlobId blobId) {
        Blob blob = this.blobStore.create(blobData, headers, blobId);
        this.creates.add(blob.getId());
        return blob;
    }

    public Blob create(Path sourceFile, Map<String, String> headers, long size, HashCode sha1) {
        Blob blob = this.blobStore.create(sourceFile, headers, size, sha1);
        this.creates.add(blob.getId());
        return blob;
    }

    public Blob copy(BlobId blobId, Map<String, String> headers) {
        Blob blob = this.blobStore.copy(blobId, headers);
        this.creates.add(blob.getId());
        return blob;
    }

    public Blob get(BlobId blobId, boolean includeDeleted) {
        return includeDeleted || !this.deletes.contains(blobId) ? this.blobStore.get(blobId) : null;
    }

    public boolean exists(BlobId blobId) {
        return this.blobStore.exists(blobId);
    }

    public boolean delete(BlobId blobId) {
        return this.deletes.add(blobId);
    }

    protected void doCommit() {
        this.deleteChangeSet(this.deletes, "committing " + this.reason());
        this.resetState();
    }

    protected void doRollback() {
        this.deleteChangeSet(this.creates, "rolling back " + this.reason());
        this.resetState();
    }

    public void close() {
        if (!this.creates.isEmpty() || !this.deletes.isEmpty()) {
            log.warn("Uncommitted changes on close");
            this.rollback();
        }
    }

    private void deleteChangeSet(Set<BlobId> changeSet, String reason) {
        for (BlobId blobId : changeSet) {
            try {
                this.blobStore.delete(blobId, reason);
            }
            catch (Throwable e) {
                log.warn("Problem deleting {}:{} while {}", new Object[]{this.storeName(), blobId, reason, e});
            }
        }
    }

    private String storeName() {
        try {
            return this.blobStore.getBlobStoreConfiguration().getName();
        }
        catch (Throwable throwable) {
            return "<unknown>";
        }
    }

    private void resetState() {
        this.creates.clear();
        this.deletes.clear();
    }
}

