/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.sonatype.nexus.blobstore.AttributesLocation;
import org.sonatype.nexus.blobstore.BlobIdLocationResolver;
import org.sonatype.nexus.blobstore.BlobStoreSupport;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.blobstore.api.BlobId;
import org.sonatype.nexus.common.log.DryRunPrefix;

public abstract class CloudBlobStoreSupport<T extends AttributesLocation>
extends BlobStoreSupport<T> {
    protected CloudBlobStoreSupport(BlobIdLocationResolver blobIdLocationResolver, DryRunPrefix dryRunPrefix) {
        super(blobIdLocationResolver, dryRunPrefix);
    }

    protected abstract Blob writeBlobProperties(BlobId var1, Map<String, String> var2);

    @Override
    protected BlobId getBlobId(Map<String, String> headers, BlobId assignedBlobId) {
        return super.getBlobId(this.removeTemporaryBlobHeaderIfPresent(headers), assignedBlobId);
    }

    public final Blob makeBlobPermanent(BlobId blobId, Map<String, String> headers) {
        if (headers.containsKey("BlobStore.temporary-blob")) {
            throw new IllegalArgumentException(String.format("Permanent blob headers must not contain entry with '%s' key.", "BlobStore.temporary-blob"));
        }
        return Optional.ofNullable(this.get(blobId)).map(Blob::getHeaders).filter(blobHeaders -> blobHeaders.containsKey("BlobStore.temporary-blob")).map(__ -> this.writeBlobProperties(blobId, headers)).orElseGet(() -> super.makeBlobPermanent(blobId, headers));
    }

    private Map<String, String> removeTemporaryBlobHeaderIfPresent(Map<String, String> headers) {
        Map<String, String> headersCopy = headers;
        if (headersCopy.containsKey("BlobStore.temporary-blob")) {
            headersCopy = new HashMap<String, String>(headers);
            headersCopy.remove("BlobStore.temporary-blob");
        }
        return headersCopy;
    }
}

