/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import org.sonatype.nexus.blobstore.api.BlobStoreConfiguration;

public class BlobStoreConfigurationBuilder {
    private final Supplier<BlobStoreConfiguration> configurationSupplier;
    private final String name;
    private String type;
    private String quotaType;
    private long quotaLimit;

    public BlobStoreConfigurationBuilder(String name, Supplier<BlobStoreConfiguration> configurationSupplier) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.configurationSupplier = (Supplier)Preconditions.checkNotNull(configurationSupplier);
    }

    public BlobStoreConfigurationBuilder type(String type) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
        return this;
    }

    public BlobStoreConfigurationBuilder quotaConfig(String quotaType, long limit) {
        this.quotaType = quotaType;
        this.quotaLimit = limit;
        return this;
    }

    public BlobStoreConfiguration build() {
        BlobStoreConfiguration configuration = this.configurationSupplier.get();
        configuration.setName(this.name);
        configuration.setType(this.type);
        if (this.quotaType != null) {
            configuration.attributes("blobStoreQuotaConfig").set("quotaType", (Object)this.quotaType);
            configuration.attributes("blobStoreQuotaConfig").set("quotaLimitBytes", (Object)this.quotaLimit);
        }
        return configuration;
    }
}

