/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.datastore.internal.ui;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.sonatype.nexus.datastore.internal.DataStoreConfigurationService;
import com.sonatype.nexus.datastore.internal.ui.DataStoreXO;
import com.sonatype.nexus.datastore.internal.ui.MutableDataStoreXO;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;
import org.sonatype.nexus.rest.ValidationErrorsException;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.siesta.ResourceSupport;
import org.sonatype.nexus.validation.Validate;

@Named
@Singleton
@Path(value="internal/ui/datastore")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DataStoreInternalResource
extends ResourceSupport {
    public static final String RESOURCE_PATH = "internal/ui/datastore";
    private static final String JDBC_URL = "jdbcUrl";
    private static final String USERNAME = "username";
    private static final String SCHEMA = "schema";
    private static final String PASSWORD_ATTRIBUTE = "password";
    private static final String ADVANCED = "advanced";
    private static final String MAX_CONNECTION_POOL_SIZE = "maximumPoolSize";
    private static final Set<String> KNOWN_ATTRIBUTES = ImmutableSet.of((Object)"jdbcUrl", (Object)"schema", (Object)"username", (Object)"password", (Object)"maximumPoolSize", (Object)"advanced", (Object[])new String[0]);
    private static final String PASSWORD_PATTERN = "password=.*";
    private static final String AMPERSAND = "&";
    private static final String QUESTION_MARK = "?";
    private static final String PASSWORD_REPLACEMENT = "password=**REDACTED**";
    private final DataStoreConfigurationService dataStoreConfigurationService;

    @Inject
    public DataStoreInternalResource(DataStoreConfigurationService dataStoreConfigurationService) {
        this.dataStoreConfigurationService = dataStoreConfigurationService;
    }

    @Timed
    @ExceptionMetered
    @GET
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public DataStoreXO read() {
        return DataStoreInternalResource.asDataStoreXO(this.getConfiguration());
    }

    @Timed
    @ExceptionMetered
    @Validate
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:*"})
    public DataStoreXO update(@NotNull @Valid MutableDataStoreXO dataStore) throws Exception {
        try {
            return DataStoreInternalResource.asDataStoreXO(this.dataStoreConfigurationService.update(this.asConfiguration(dataStore)).getConfiguration());
        }
        catch (IllegalArgumentException e) {
            this.log.info("Request to set invalid configuration for data store", (Throwable)e);
            throw new ValidationErrorsException().withError(ADVANCED, "The advanced configuration is invalid or contains unknown properties");
        }
    }

    private DataStoreConfiguration asConfiguration(MutableDataStoreXO dataStoreXO) {
        DataStoreConfiguration configuration = DataStoreInternalResource.copy(this.getConfiguration());
        Map<String, String> attributes = configuration.getAttributes().entrySet().stream().filter(e -> KNOWN_ATTRIBUTES.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (dataStoreXO.getMaximumConnectionPool() != null) {
            attributes.put(MAX_CONNECTION_POOL_SIZE, dataStoreXO.getMaximumConnectionPool().toString());
        }
        attributes.put(ADVANCED, dataStoreXO.getAdvanced() == null ? "" : dataStoreXO.getAdvanced());
        configuration.setAttributes(attributes);
        return configuration;
    }

    private DataStoreConfiguration getConfiguration() {
        return this.dataStoreConfigurationService.getDataStores().stream().filter(dataStore -> "nexus".equals(dataStore.getName())).findAny().orElseThrow(() -> new WebApplicationMessageException(Response.Status.INTERNAL_SERVER_ERROR, "Unable to locate datastore."));
    }

    private static DataStoreXO asDataStoreXO(DataStoreConfiguration dataStore) {
        Map attributes = dataStore.getAttributes();
        String jdbcUrl = DataStoreInternalResource.redactPasswordInJdbcUrl((String)attributes.get(JDBC_URL));
        String username = (String)attributes.get(USERNAME);
        String schema = (String)attributes.get(SCHEMA);
        String advanced = (String)attributes.get(ADVANCED);
        Integer maxConnectionPoolSize = Optional.ofNullable((String)attributes.get(MAX_CONNECTION_POOL_SIZE)).map(Integer::valueOf).orElse(null);
        return new DataStoreXO(username, jdbcUrl, schema, maxConnectionPoolSize, advanced);
    }

    private static DataStoreConfiguration copy(DataStoreConfiguration original) {
        DataStoreConfiguration copy = new DataStoreConfiguration();
        copy.setAttributes(new HashMap(original.getAttributes()));
        copy.setName(original.getName());
        copy.setSource(original.getSource());
        copy.setType(original.getType());
        return copy;
    }

    @VisibleForTesting
    static String redactPasswordInJdbcUrl(String jdbcUrl) {
        if (jdbcUrl.contains(QUESTION_MARK)) {
            int questionMarkIndex = jdbcUrl.indexOf(QUESTION_MARK);
            return String.valueOf(jdbcUrl.substring(0, questionMarkIndex + 1)) + Arrays.stream(jdbcUrl.substring(questionMarkIndex + 1).split(AMPERSAND)).map(queryParam -> queryParam.toLowerCase().replaceAll(PASSWORD_PATTERN, PASSWORD_REPLACEMENT)).collect(Collectors.joining(AMPERSAND));
        }
        return jdbcUrl;
    }
}

