/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.datastore.internal.rest;

import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import javax.validation.constraints.NotEmpty;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;

public class DataStoreApiXO {
    @ApiModelProperty(value="The source of the data store.", allowableValues="local")
    @NotEmpty
    private String source;
    @ApiModelProperty(value="The type of the data store.", allowableValues="jdbc")
    @NotEmpty
    private String type;
    @ApiModelProperty(value="The name of the data store.")
    @NotEmpty
    private String name;
    @ApiModelProperty(value="The JDBC connection URL for the data store.", required=true)
    @NotEmpty
    private String jdbcUrl;
    @ApiModelProperty(value="The username to use for the JDBC connection.", example="")
    private String username;
    private String schema;
    private String advanced;

    public DataStoreApiXO() {
    }

    public DataStoreApiXO(DataStoreConfiguration configuration) {
        this.name = configuration.getName();
        this.type = configuration.getType();
        this.source = configuration.getSource();
        this.jdbcUrl = (String)configuration.getAttributes().get("jdbcUrl");
        this.username = (String)configuration.getAttributes().get("username");
        this.schema = (String)configuration.getAttributes().get("schema");
        this.advanced = (String)configuration.getAttributes().get("advanced");
    }

    public String getAdvanced() {
        return this.advanced;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getSource() {
        return this.source;
    }

    public String getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    public void setAdvanced(String advanced) {
        this.advanced = advanced;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public DataStoreConfiguration toDataStoreConfiguration() {
        DataStoreConfiguration configuration = new DataStoreConfiguration();
        configuration.setName(this.name);
        configuration.setSource(this.source);
        configuration.setType(this.type);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("jdbcUrl", this.jdbcUrl);
        if (!Strings2.isBlank((String)this.username)) {
            attributes.put("username", this.username);
        }
        if (!Strings2.isBlank((String)this.schema)) {
            attributes.put("schema", this.schema);
        }
        if (!Strings2.isBlank((String)this.advanced)) {
            attributes.put("advanced", this.advanced);
        }
        configuration.setAttributes(attributes);
        return configuration;
    }
}

