/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.datastore.internal.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.sonatype.nexus.datastore.internal.DataStoreConfigurationService;
import com.sonatype.nexus.datastore.internal.rest.DataStoreApiResourceDoc;
import com.sonatype.nexus.datastore.internal.rest.DataStoreApiUpdateXO;
import com.sonatype.nexus.datastore.internal.rest.DataStoreApiXO;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;

@Named
@Singleton
@Path(value="/beta/data-store/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DataStoreApiResource
extends ComponentSupport
implements Resource,
DataStoreApiResourceDoc {
    public static final String RESOURCE_URI = "/beta/data-store/";
    private static final Set<String> mutableFields = Sets.newHashSet((Object[])new String[]{"attributes->advanced"});
    private final DataStoreConfigurationService dataStoreConfigurationService;
    private final ObjectMapper mapper = new ObjectMapper();

    @Inject
    public DataStoreApiResource(DataStoreConfigurationService dataStoreConfigurationService) {
        this.dataStoreConfigurationService = dataStoreConfigurationService;
    }

    @Override
    @GET
    public DataStoreApiXO getDataStore() throws Exception {
        return this.dataStoreConfigurationService.getDataStore("nexus").map(DataStoreApiXO::new).orElseThrow(() -> this.webException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Failed to get datastore %s", "nexus")));
    }

    @Override
    @PUT
    public void updateDataStore(@Valid DataStoreApiUpdateXO apiDataStore) throws Exception {
        try {
            DataStoreConfiguration oldConfiguration = this.dataStoreConfigurationService.getDataStore("nexus").orElseThrow(() -> this.webException(Response.Status.INTERNAL_SERVER_ERROR, String.format("Failed to get existing datastore %s", "nexus")));
            if (apiDataStore.getPassword() == null) {
                Optional.ofNullable((String)oldConfiguration.getAttributes().get("password")).ifPresent(apiDataStore::setPassword);
            }
            DataStoreConfiguration newConfiguration = apiDataStore.toDataStoreConfiguration();
            this.validateDataStoreConfigurationChange(oldConfiguration, newConfiguration);
            this.dataStoreConfigurationService.update(newConfiguration);
        }
        catch (Exception e) {
            this.maybeHumanException(e, apiDataStore.getName());
        }
    }

    private void validateDataStoreConfigurationChange(DataStoreConfiguration oldConfiguration, DataStoreConfiguration newConfiguration) {
        Map diff = DataStoreConfiguration.diff((DataStoreConfiguration)oldConfiguration, (DataStoreConfiguration)newConfiguration);
        Optional<String> maybeError = diff.entrySet().stream().filter(entry -> !mutableFields.contains(entry.getKey())).map(invalidEntry -> String.format("Not allowed to set %s to value %s.", invalidEntry.getKey(), DataStoreApiResource.toString((Map)invalidEntry.getValue()))).reduce((e1, e2) -> String.valueOf(e1) + " " + e2);
        if (maybeError.isPresent()) {
            this.log.error("Invalid datastore update request: {}", (Object)maybeError.get());
            throw this.webException(Response.Status.BAD_REQUEST, maybeError.get());
        }
    }

    private static String toString(Map<String, String> value) {
        return value.entrySet().stream().map(entry -> String.format("%s->%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(", "));
    }

    private void maybeHumanException(Exception e, String dataStoreName) throws Exception {
        for (Throwable candidate : Throwables.getCausalChain((Throwable)e)) {
            if (candidate instanceof SQLInvalidAuthorizationSpecException) {
                this.log.info("Failed to authenticate for datastore {}", (Object)dataStoreName, (Object)e);
                this.throwWebException(Response.Status.BAD_REQUEST.getStatusCode(), "Authenticating with the database failed.");
                continue;
            }
            if (candidate instanceof WebApplicationException) {
                WebApplicationException wa = (WebApplicationException)candidate;
                this.throwWebException(wa.getResponse().getStatus(), wa.getMessage());
                continue;
            }
            if (!(candidate instanceof IllegalArgumentException)) continue;
            this.log.info("Failed to apply update for datastore {}", (Object)dataStoreName);
            this.throwWebException(Response.Status.BAD_REQUEST.getStatusCode(), "Invalid configuration, update failed");
        }
        throw e;
    }

    private WebApplicationMessageException webException(Response.Status status, String message) {
        try {
            return new WebApplicationMessageException(status, (Object)this.mapper.writeValueAsString((Object)message), "application/json");
        }
        catch (JsonProcessingException e) {
            this.log.error("Failed to create json msg from '{}'", (Object)message);
            throw new UncheckedIOException((IOException)((Object)e));
        }
    }

    private void throwWebException(int statusCode, String message) throws Exception {
        throw new WebApplicationMessageException(Response.Status.fromStatusCode((int)statusCode), (Object)this.mapper.writeValueAsString((Object)message), "application/json");
    }
}

