/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.datastore.internal;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.datastore.DataStoreUsageChecker;
import org.sonatype.nexus.datastore.api.DataStore;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;
import org.sonatype.nexus.datastore.api.DataStoreManager;
import org.sonatype.nexus.distributed.event.service.api.DistributedEvent;
import org.sonatype.nexus.distributed.event.service.api.common.DataStoreConfigurationEvent;
import org.sonatype.nexus.distributed.event.service.api.common.PublisherEvent;

@Named
@Singleton
public class DataStoreConfigurationService
extends StateGuardLifecycleSupport {
    private final DataStoreManager dataStoreManager;
    private final List<DataStoreUsageChecker> dataStoreUsageCheckers;
    private final EventManager eventManager;

    @Inject
    public DataStoreConfigurationService(DataStoreManager dataStoreManager, List<DataStoreUsageChecker> dataStoreUsageCheckers, EventManager eventManager) {
        this.dataStoreManager = dataStoreManager;
        this.dataStoreUsageCheckers = dataStoreUsageCheckers;
        this.eventManager = eventManager;
    }

    @Guarded(by={"STARTED"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:datastores:read"})
    public List<DataStoreConfiguration> getDataStores() {
        return StreamSupport.stream(this.dataStoreManager.browse().spliterator(), true).map(DataStore::getConfiguration).collect(Collectors.toList());
    }

    @Guarded(by={"STARTED"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:datastores:read"})
    public Optional<DataStoreConfiguration> getDataStore(String dataStoreName) {
        return this.dataStoreManager.get(dataStoreName).map(DataStore::getConfiguration);
    }

    @Guarded(by={"STARTED"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:datastores:create"})
    public DataStore<?> create(@NotNull DataStoreConfiguration configuration) throws Exception {
        if (this.dataStoreManager.exists(configuration.getName())) {
            throw new WebApplicationException("Data store '" + configuration.getName() + "' already exists.", Response.Status.CONFLICT);
        }
        return this.dataStoreManager.create(configuration);
    }

    @Guarded(by={"STARTED"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:datastores:update"})
    public DataStore<?> update(@NotNull DataStoreConfiguration configuration) throws Exception {
        this.ensureDataStoreExists(configuration.getName());
        this.eventManager.post((Object)new PublisherEvent((DistributedEvent)new DataStoreConfigurationEvent(configuration.getName(), configuration.getType(), configuration.getSource(), configuration.getAttributes())));
        return this.dataStoreManager.update(configuration);
    }

    @Guarded(by={"STARTED"})
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:datastores:delete"})
    public void delete(@NotNull String dataStoreName) throws Exception {
        boolean isInUse = this.dataStoreUsageCheckers.stream().anyMatch(dataStoreUsageChecker -> dataStoreUsageChecker.isDataStoreUsed(dataStoreName));
        if (isInUse) {
            throw new WebApplicationException("The data store '" + dataStoreName + "' is in use.", Response.Status.BAD_REQUEST);
        }
        this.ensureDataStoreExists(dataStoreName);
        this.dataStoreManager.delete(dataStoreName);
    }

    private void ensureDataStoreExists(String dataStoreName) {
        if (!this.dataStoreManager.exists(dataStoreName)) {
            throw new WebApplicationException("The data store '" + dataStoreName + "' is unknown.", Response.Status.NOT_FOUND);
        }
    }
}

