/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.datastore.internal;

import com.sonatype.nexus.datastore.internal.DataStoreConfigurationFeature;
import com.sonatype.nexus.datastore.internal.DataStoreConfigurationService;
import com.sonatype.nexus.licensing.ext.capability.LicensingConditions;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.goodies.i18n.I18N;
import org.sonatype.goodies.i18n.MessageBundle;
import org.sonatype.licensing.feature.Feature;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;
import org.sonatype.nexus.capability.CapabilityDescriptorSupport;
import org.sonatype.nexus.capability.CapabilitySupport;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.Tag;
import org.sonatype.nexus.capability.Taggable;
import org.sonatype.nexus.formfields.FormField;

@Named(value="datastore-configuration")
public class DataStoreConfigurationCapability
extends CapabilitySupport<Configuration> {
    public static final String TYPE_ID = "datastore-configuration";
    public static final CapabilityType TYPE = CapabilityType.capabilityType((String)"datastore-configuration");
    private static final Messages messages = (Messages)I18N.create(Messages.class);
    private final LicensingConditions licensingConditions;
    private final DataStoreConfigurationService dataStoreConfigurationService;
    private final DataStoreConfigurationFeature feature;

    @Inject
    public DataStoreConfigurationCapability(DataStoreConfigurationService dataStoreConfigurationService, LicensingConditions licensingConditions, DataStoreConfigurationFeature feature) {
        this.dataStoreConfigurationService = dataStoreConfigurationService;
        this.licensingConditions = licensingConditions;
        this.feature = feature;
    }

    protected Configuration createConfig(Map<String, String> properties) {
        return new Configuration(properties);
    }

    @Nullable
    protected String renderDescription() {
        return this.context().isActive() ? messages.enabled() : messages.disabled();
    }

    public Condition activationCondition() {
        return this.conditions().logical().and(new Condition[]{this.licensingConditions.licenseIsValid((Feature)this.feature), this.conditions().capabilities().passivateCapabilityDuringUpdate()});
    }

    protected void onActivate(Configuration config) throws Exception {
        this.dataStoreConfigurationService.start();
    }

    protected void onPassivate(Configuration config) throws Exception {
        this.dataStoreConfigurationService.stop();
    }

    public static class Configuration
    extends CapabilityConfigurationSupport {
        public Configuration(Map<String, String> properties) {
        }
    }

    @Named(value="datastore-configuration")
    public static class Descriptor
    extends CapabilityDescriptorSupport<Configuration>
    implements Taggable {
        public Descriptor() {
            this.setExposed(false);
            this.setHidden(true);
        }

        public CapabilityType type() {
            return TYPE;
        }

        public String name() {
            return messages.name();
        }

        public List<FormField> formFields() {
            return Collections.emptyList();
        }

        protected Configuration createConfig(Map<String, String> properties) {
            return new Configuration(properties);
        }

        protected String renderAbout() {
            return this.render("$TYPE_ID-about.vm");
        }

        public Set<Tag> getTags() {
            return Collections.singleton(Tag.categoryTag((String)messages.category()));
        }
    }

    private static interface Messages
    extends MessageBundle {
        @MessageBundle.DefaultMessage(value="DataStore Configuration")
        public String name();

        @MessageBundle.DefaultMessage(value="DataStore Configuration")
        public String category();

        @MessageBundle.DefaultMessage(value="Disabled")
        public String disabled();

        @MessageBundle.DefaultMessage(value="Enabled")
        public String enabled();
    }
}

