/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.datastore;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.sonatype.nexus.datastore.DataStoreConfigurationSourceSupport;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.property.PropertiesFile;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.datastore.DataStoreConfigurationSource;
import org.sonatype.nexus.datastore.api.DataStoreConfiguration;

@Named(value="local")
@Priority(value=0)
@Singleton
public class DataStoreConfigurationFileSource
extends ComponentSupport
implements DataStoreConfigurationSource {
    static final String LOCAL = "local";
    private static final String JDBC_TEMPLATE_URL = "jdbc:h2:file:${karaf.data}/db/${storeName}";
    private static final String NAME_KEY = "name";
    private static final String TYPE_KEY = "type";
    private static final String JDBC_URL = "jdbcUrl";
    private static final Set<String> TOP_LEVEL_KEYS = ImmutableSet.of((Object)"name", (Object)"type");
    private static final String STORE_PROPERTIES_SUFFIX = "-store.properties";
    private static final String SYSTEM_PROPERTY_PREFIX = "nexus.datastore.";
    private static final String ENV_PREFIX = "NEXUS_DATASTORE_";
    private final Map<String, PropertiesFile> propertiesByStoreName = new ConcurrentHashMap<String, PropertiesFile>();
    private final File fabricWorkDirectory;

    @Inject
    public DataStoreConfigurationFileSource(ApplicationDirectories directories) {
        this.fabricWorkDirectory = ((ApplicationDirectories)Preconditions.checkNotNull((Object)directories)).getWorkDirectory("etc/fabric");
    }

    public String getName() {
        return "Local";
    }

    public boolean isModifiable() {
        return true;
    }

    public Iterable<String> browseStoreNames() {
        ImmutableSet.Builder storeNames = ImmutableSet.builder();
        storeNames.add((Object)"nexus");
        File[] files = this.fabricWorkDirectory.listFiles();
        if (files != null) {
            Arrays.stream(files).filter(File::canRead).map(File::getName).filter(name -> name.endsWith(STORE_PROPERTIES_SUFFIX)).map(name -> name.substring(0, name.indexOf(STORE_PROPERTIES_SUFFIX))).filter(DataStoreConfigurationSourceSupport.VALID_NAME_PATTERN.asPredicate()).forEach(arg_0 -> ((ImmutableSet.Builder)storeNames).add(arg_0));
        }
        return storeNames.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataStoreConfiguration load(String storeName) {
        PropertiesFile storeProperties;
        DataStoreConfigurationSourceSupport.checkName(storeName);
        PropertiesFile propertiesFile = storeProperties = this.findStoreProperties(storeName);
        synchronized (propertiesFile) {
            String jdbcUrl;
            try {
                if (storeProperties.exists()) {
                    storeProperties.load();
                    DataStoreConfigurationFileSource.maybeTrimProperties(storeProperties);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            String storeType = storeProperties.getProperty(TYPE_KEY);
            if (Strings2.isBlank((String)storeType)) {
                storeType = "jdbc";
            }
            if (Strings2.isBlank((String)(jdbcUrl = storeProperties.getProperty(JDBC_URL)))) {
                storeProperties.setProperty(JDBC_URL, JDBC_TEMPLATE_URL);
            }
            DataStoreConfiguration configuration = new DataStoreConfiguration();
            configuration.setName(storeName);
            configuration.setType(storeType);
            configuration.setAttributes(Maps.filterKeys((Map)Maps.fromProperties((Properties)storeProperties), (Predicate)Predicates.not((Predicate)Predicates.in(TOP_LEVEL_KEYS))));
            configuration.setSource(LOCAL);
            jdbcUrl = configuration.getAttributes().getOrDefault(JDBC_URL, "");
            String jdbcDriver = Arrays.stream(jdbcUrl.split(":")).skip(1L).findFirst().orElse("malformed jdbcUrl: " + jdbcUrl);
            this.log.info("Loaded '{}' data store configuration from properties file ({})", (Object)storeName, (Object)jdbcDriver);
            return configuration;
        }
    }

    private static void maybeTrimProperties(PropertiesFile propertiesFile) {
        for (Map.Entry entry : propertiesFile.entrySet()) {
            String value;
            String trimmedValue;
            if (DataStoreConfiguration.isSensitiveKey((String)entry.getKey().toString()) || (trimmedValue = (value = entry.getValue().toString()).trim()).equals(value)) continue;
            entry.setValue(trimmedValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(DataStoreConfiguration configuration) {
        PropertiesFile storeProperties;
        String storeName = configuration.getName();
        DataStoreConfigurationSourceSupport.checkName(storeName);
        PropertiesFile propertiesFile = storeProperties = this.findStoreProperties(storeName);
        synchronized (propertiesFile) {
            storeProperties.putAll(configuration.getAttributes());
            try {
                storeProperties.store();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(DataStoreConfiguration configuration) {
        String storeName = configuration.getName();
        PropertiesFile storeProperties = this.propertiesByStoreName.get(storeName);
        if (storeProperties != null) {
            PropertiesFile propertiesFile = storeProperties;
            synchronized (propertiesFile) {
                storeProperties.getFile().delete();
            }
        }
    }

    public File getPropertiesFile(String storeName) {
        return new File(this.fabricWorkDirectory, String.valueOf(storeName) + STORE_PROPERTIES_SUFFIX);
    }

    private PropertiesFile findStoreProperties(String storeName) {
        return this.propertiesByStoreName.computeIfAbsent(storeName, this::initializeStoreProperties);
    }

    private PropertiesFile initializeStoreProperties(String storeName) {
        PropertiesFile storeProperties = new PropertiesFile(this.getPropertiesFile(storeName));
        String envPrefix = ENV_PREFIX + storeName.toUpperCase() + '_';
        System.getenv().keySet().stream().filter(k -> k.startsWith(envPrefix)).forEach(key -> {
            Object object = storeProperties.setProperty(DataStoreConfigurationFileSource.envToProperty(key.substring(envPrefix.length())), System.getenv(key));
        });
        String systemPrefix = SYSTEM_PROPERTY_PREFIX + storeName + '.';
        System.getProperties().stringPropertyNames().stream().filter(k -> k.startsWith(systemPrefix)).forEach(k -> {
            Object object = storeProperties.setProperty(k.substring(systemPrefix.length()), System.getProperty(k));
        });
        return storeProperties;
    }

    private static String envToProperty(String key) {
        return key.replaceAll("_", ".").toLowerCase().replaceAll("jdbcurl", JDBC_URL);
    }
}

