/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.outreach;

import com.google.common.io.ByteSource;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundleEntry;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundleMetadata;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;

public class PageBundle
extends ComponentSupport {
    public static final String METADATA_ENTRY = ".metadata";
    private final String id;
    private ZipFile zip;
    private PageBundleMetadata metadata;
    private File backingFile;
    private File mdFile;

    public PageBundle(File tmpDir, String id) {
        this.id = id;
        this.backingFile = new File(tmpDir, "outreach/" + id);
        this.mdFile = new File(this.backingFile.getParentFile(), String.valueOf(id) + METADATA_ENTRY);
        this.refresh();
    }

    public String getId() {
        return this.id;
    }

    public boolean exists() {
        return this.zip != null;
    }

    public PageBundleEntry getEntry(String path) {
        if (!this.exists()) {
            return new PageBundleEntry.MissingPageBundleEntry(path);
        }
        ZipEntry entry = null;
        if (path != null) {
            entry = this.zip.getEntry(path);
        }
        if ("".equals(path) || path == null) {
            entry = this.zip.getEntry("index.html");
        } else {
            ZipEntry dirEntry = this.zip.getEntry(String.valueOf(path) + "/");
            if (entry == null || dirEntry != null && dirEntry.isDirectory()) {
                entry = this.zip.getEntry(FilenameUtils.normalize((String)(String.valueOf(path) + "/index.html")));
            }
        }
        return new PageBundleEntry(this.zip, entry);
    }

    public PageBundleMetadata getMetaData() {
        if (this.metadata != null) {
            return this.metadata;
        }
        if (this.mdFile.exists()) {
            try {
                this.metadata = new PageBundleMetadata(this.mdFile);
                return this.metadata;
            }
            catch (IOException e) {
                this.log.warn("Could not read metadata file: {}", (Object)this.mdFile, (Object)e);
            }
        }
        this.metadata = new PageBundleMetadata();
        return this.metadata;
    }

    private void refresh() {
        block14: {
            this.log.trace("refreshing page bundle ({})", (Object)this.id);
            if (this.zip != null) {
                try {
                    this.zip.close();
                }
                catch (IOException e) {
                    this.log.warn("Could not close zip file", (Throwable)e);
                }
            }
            this.zip = null;
            this.metadata = null;
            if (this.backingFile.exists()) {
                this.log.trace("page bundle file exists {}", (Object)this.backingFile);
                try {
                    this.zip = new ZipFile(this.backingFile);
                    this.extractMetadata();
                    DateTime expires = this.getMetaData().getExpires();
                    if (expires == null || !expires.isBeforeNow()) break block14;
                    try {
                        try {
                            this.zip.close();
                            this.backingFile.delete();
                        }
                        catch (IOException e) {
                            this.log.warn("Could not remove expired page bundle contents", (Throwable)e);
                            this.zip = null;
                        }
                    }
                    finally {
                        this.zip = null;
                    }
                }
                catch (IOException e) {
                    try {
                        if (this.zip != null) {
                            this.zip.close();
                        }
                    }
                    catch (Throwable t) {
                        this.log.warn("Problem closing zip file", t);
                    }
                    this.zip = null;
                    this.log.warn("Could not use bundle file", (Throwable)e);
                }
            }
        }
    }

    public void updated() {
        try {
            if (!this.mdFile.exists()) {
                this.mdFile.createNewFile();
            } else {
                this.mdFile.setLastModified(System.currentTimeMillis());
            }
        }
        catch (IOException e) {
            this.log.warn("Could not create or update timestamp of bundle metadata", (Throwable)e);
        }
    }

    private void extractMetadata() throws IOException {
        try {
            this.extract(METADATA_ENTRY);
        }
        catch (IOException e) {
            this.log.warn("Could not write metadata", (Throwable)e);
            throw e;
        }
    }

    private void extract(String name) throws IOException {
        this.log.trace("extracting {} from bundle", (Object)name);
        final ZipEntry entry = this.zip.getEntry(name);
        File file = new File(this.backingFile.getParentFile(), String.valueOf(this.backingFile.getName()) + name);
        if (entry != null && file.exists() && (entry.getTime() < file.lastModified() || file.lastModified() < this.backingFile.lastModified())) {
            return;
        }
        if (entry != null) {
            new ByteSource(){

                public InputStream openStream() throws IOException {
                    return PageBundle.this.zip.getInputStream(entry);
                }
            }.copyTo(Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]));
        } else {
            this.log.trace("no entry found, creating empty file");
            file.createNewFile();
        }
    }

    public long lastModified() {
        if (this.mdFile.exists()) {
            return this.mdFile.lastModified();
        }
        return this.backingFile.lastModified();
    }

    public void use(File tmpFile) throws IOException {
        this.log.trace("using file {} ({})", (Object)tmpFile, (Object)this.id);
        this.dispose();
        Files.createParentDirs((File)this.backingFile);
        Files.move((File)tmpFile, (File)this.backingFile);
        this.refresh();
        this.updated();
    }

    public void dispose() {
        try {
            if (this.zip != null) {
                this.zip.close();
            }
        }
        catch (IOException e) {
            this.log.warn("Could not close page bundle zip file", (Throwable)e);
        }
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "id='" + this.id + '\'' + '}';
    }
}

