/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach.internal.outreach;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.plugins.outreach.internal.OutreachHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;

@Named
public class OutreachConnector
extends ComponentSupport {
    private final OutreachHelper outreachHelper;
    private final Provider<CloseableHttpClient> httpClientProvider;

    @Inject
    public OutreachConnector(OutreachHelper outreachHelper, Provider<CloseableHttpClient> httpClientProvider) {
        this.outreachHelper = (OutreachHelper)((Object)Preconditions.checkNotNull((Object)((Object)outreachHelper)));
        this.httpClientProvider = (Provider)Preconditions.checkNotNull(httpClientProvider);
    }

    public Response head(String url) throws IOException {
        HttpHead head = new HttpHead(url);
        Throwable throwable = null;
        Object var4_5 = null;
        try (CloseableHttpClient client = (CloseableHttpClient)this.httpClientProvider.get();){
            return new Response((HttpResponse)client.execute((HttpUriRequest)head));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Response get(String url) throws IOException {
        HttpGet get = new HttpGet(url);
        Throwable throwable = null;
        Object var4_5 = null;
        try (CloseableHttpClient client = (CloseableHttpClient)this.httpClientProvider.get();){
            return new Response((HttpResponse)client.execute((HttpUriRequest)get));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public class Response {
        private final StatusLine statusLine;
        private DateTime lastModified;
        private File file;

        Response(HttpResponse response) throws IOException {
            block14: {
                Date date;
                this.statusLine = response.getStatusLine();
                Header header = response.getFirstHeader("Last-Modified");
                if (header != null && (date = DateUtils.parseDate((String)header.getValue())) != null) {
                    this.lastModified = new DateTime((Object)date);
                }
                if (response.getEntity() != null) {
                    try {
                        if (this.statusLine.getStatusCode() != 200) break block14;
                        Throwable throwable = null;
                        Object var5_6 = null;
                        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(this.getFile()));){
                            response.getEntity().writeTo((OutputStream)output);
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                    }
                }
            }
        }

        public DateTime lastModified() {
            return this.lastModified;
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(OutreachConnector.this.outreachHelper.getTemporaryDirectory(), this.createFileName());
            }
            return this.file;
        }

        private String createFileName() {
            return String.valueOf(UUID.randomUUID().toString().replace("-", "")) + ".tmp";
        }

        public StatusLine getStatusLine() {
            return this.statusLine;
        }

        public boolean isSuccess() {
            return this.statusLine.getStatusCode() >= 200 && this.statusLine.getStatusCode() < 300;
        }

        public String toString() {
            return "Response{statusLine=" + this.statusLine + ", lastModified=" + this.lastModified + ", file=" + this.file + '}';
        }
    }
}

