/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.plugins.outreach;

import com.sonatype.nexus.plugins.outreach.internal.OutreachHelper;
import com.sonatype.nexus.plugins.outreach.internal.outreach.PageBundle;
import java.util.Locale;
import org.apache.shiro.subject.Subject;

public interface Outreach {
    public PageBundle getPageBundle(User var1, Locale var2);

    public static enum User {
        NONE,
        ANONYMOUS,
        USER,
        ADMIN;


        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }

        public static User fromSubject(Subject subject, OutreachHelper outreachHelper) {
            if (subject == null) {
                return NONE;
            }
            if (subject.hasRole("nx-anonymous")) {
                return ANONYMOUS;
            }
            if (outreachHelper.hasAdminRole(subject)) {
                return ADMIN;
            }
            if (subject.isAuthenticated() || subject.isRemembered()) {
                return USER;
            }
            return NONE;
        }
    }
}

