/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition.internal;

import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.condition.internal.CompositeConditionSupport;
import org.sonatype.nexus.common.event.EventManager;

public class DisjunctionCondition
extends CompositeConditionSupport
implements Condition {
    private Condition lastSatisfied;

    public DisjunctionCondition(EventManager eventManager, Condition ... conditions) {
        super(eventManager, conditions);
    }

    @Override
    protected boolean reevaluate(Condition ... conditions) {
        Condition[] conditionArray = conditions;
        int n = conditions.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            if (condition.isSatisfied()) {
                this.lastSatisfied = condition;
                return true;
            }
            ++n2;
        }
        this.lastSatisfied = null;
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Condition[] conditionArray = this.getConditions();
        int n = conditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(condition);
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public String explainSatisfied() {
        if (this.lastSatisfied != null) {
            return this.lastSatisfied.explainSatisfied();
        }
        StringBuilder sb = new StringBuilder();
        Condition[] conditionArray = this.getConditions();
        int n = conditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(condition.explainSatisfied());
            ++n2;
        }
        return sb.toString();
    }

    @Override
    public String explainUnsatisfied() {
        StringBuilder sb = new StringBuilder();
        Condition[] conditionArray = this.getConditions();
        int n = conditionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Condition condition = conditionArray[n2];
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            sb.append(condition.explainUnsatisfied());
            ++n2;
        }
        return sb.toString();
    }
}

