/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import java.util.HashMap;
import java.util.List;

public interface OTransaction {
    public void begin();

    public void commit();

    public void commit(boolean var1);

    public void rollback();

    public ISOLATION_LEVEL getIsolationLevel();

    public OTransaction setIsolationLevel(ISOLATION_LEVEL var1);

    public void rollback(boolean var1, int var2);

    public ODatabaseDocument getDatabase();

    public void clearRecordEntries();

    @Deprecated
    public ORecord loadRecord(ORID var1, ORecord var2, String var3, boolean var4, boolean var5, OStorage.LOCKING_STRATEGY var6);

    @Deprecated
    public ORecord loadRecord(ORID var1, ORecord var2, String var3, boolean var4, boolean var5, boolean var6, OStorage.LOCKING_STRATEGY var7);

    public ORecord loadRecord(ORID var1, ORecord var2, String var3, boolean var4);

    public ORecord reloadRecord(ORID var1, ORecord var2, String var3, boolean var4);

    public ORecord reloadRecord(ORID var1, ORecord var2, String var3, boolean var4, boolean var5);

    public ORecord loadRecordIfVersionIsNotLatest(ORID var1, int var2, String var3, boolean var4) throws ORecordNotFoundException;

    public ORecord saveRecord(ORecord var1, String var2, ODatabase.OPERATION_MODE var3, boolean var4, ORecordCallback<? extends Number> var5, ORecordCallback<Integer> var6);

    public void deleteRecord(ORecord var1, ODatabase.OPERATION_MODE var2);

    public void recycleRecord(ORecord var1);

    public int getId();

    public TXSTATUS getStatus();

    @Deprecated
    public Iterable<? extends ORecordOperation> getCurrentRecordEntries();

    public Iterable<? extends ORecordOperation> getAllRecordEntries();

    public List<ORecordOperation> getNewRecordEntriesByClass(OClass var1, boolean var2);

    public List<ORecordOperation> getNewRecordEntriesByClusterIds(int[] var1);

    public ORecord getRecord(ORID var1);

    public ORecordOperation getRecordEntry(ORID var1);

    public List<String> getInvolvedIndexes();

    public ODocument getIndexChanges();

    public void addIndexEntry(OIndex<?> var1, String var2, OTransactionIndexChanges.OPERATION var3, Object var4, OIdentifiable var5);

    @Deprecated
    public void clearIndexEntries();

    public OTransactionIndexChanges getIndexChanges(String var1);

    public boolean isActive();

    public boolean isUsingLog();

    public void setCustomData(String var1, Object var2);

    public Object getCustomData(String var1);

    public void setUsingLog(boolean var1);

    public void close();

    public void updateIdentityAfterCommit(ORID var1, ORID var2);

    public int amountOfNestedTxs();

    public boolean isLockedRecord(OIdentifiable var1);

    public OStorage.LOCKING_STRATEGY lockingStrategy(OIdentifiable var1);

    public OTransaction lockRecord(OIdentifiable var1, OStorage.LOCKING_STRATEGY var2);

    public OTransaction unlockRecord(OIdentifiable var1);

    public HashMap<ORID, OStorage.LOCKING_STRATEGY> getLockedRecords();

    public int getEntryCount();

    public boolean hasRecordCreation();

    public static enum ISOLATION_LEVEL {
        READ_COMMITTED,
        REPEATABLE_READ;

    }

    public static enum TXSTATUS {
        INVALID,
        BEGUN,
        COMMITTING,
        ROLLBACKING,
        COMPLETED,
        ROLLED_BACK;

    }

    public static enum TXTYPE {
        NOTX,
        OPTIMISTIC,
        PESSIMISTIC;

    }
}

