/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.sql.parser.OCollection;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OFloatingPoint;
import com.orientechnologies.orient.core.sql.parser.OFunctionCall;
import com.orientechnologies.orient.core.sql.parser.OIdentifier;
import com.orientechnologies.orient.core.sql.parser.OInteger;
import com.orientechnologies.orient.core.sql.parser.OJson;
import com.orientechnologies.orient.core.sql.parser.OJsonItem;
import com.orientechnologies.orient.core.sql.parser.ORid;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class OInputParameter
extends SimpleNode {
    protected String dateFormatString = "yyyy-MM-dd HH:mm:ss.SSS";
    protected DateFormat dateFormat = new SimpleDateFormat(this.dateFormatString);

    public OInputParameter(int id) {
        super(id);
    }

    public OInputParameter(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public Object bindFromInputParams(Map<Object, Object> params) {
        return null;
    }

    protected Object toParsedTree(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof Integer) {
            OInteger result = new OInteger(-1);
            result.setValue((Integer)value);
            return result;
        }
        if (value instanceof Number) {
            OFloatingPoint result = new OFloatingPoint(-1);
            result.sign = ((Number)value).doubleValue() >= 0.0 ? 1 : -1;
            result.stringValue = value.toString();
            if (result.stringValue.startsWith("-")) {
                result.stringValue = result.stringValue.substring(1);
            }
            return result;
        }
        if (value instanceof String) {
            return value;
        }
        if (value instanceof Map) {
            OJson json = new OJson(-1);
            json.items = new ArrayList<OJsonItem>();
            for (Map.Entry entry : ((Map)value).entrySet()) {
                OJsonItem item = new OJsonItem();
                item.leftString = "" + entry.getKey();
                OExpression exp = new OExpression(-1);
                exp.value = this.toParsedTree(entry.getValue());
                item.right = exp;
                json.items.add(item);
            }
            return json;
        }
        if (OMultiValue.isMultiValue(value) && !(value instanceof byte[]) && !(value instanceof Byte[])) {
            OCollection coll = new OCollection(-1);
            coll.expressions = new ArrayList<OExpression>();
            Iterator<Object> iterator = OMultiValue.getMultiValueIterator(value);
            while (iterator.hasNext()) {
                Object o = iterator.next();
                OExpression exp = new OExpression(-1);
                exp.value = this.toParsedTree(o);
                coll.expressions.add(exp);
            }
            return coll;
        }
        if (value instanceof OIdentifiable) {
            ORid rid = new ORid(-1);
            String stringVal = ((OIdentifiable)value).getIdentity().toString().substring(1);
            String[] splitted = stringVal.split(":");
            OInteger c = new OInteger(-1);
            c.setValue(Integer.parseInt(splitted[0]));
            rid.cluster = c;
            OInteger p = new OInteger(-1);
            p.setValue(Integer.parseInt(splitted[1]));
            rid.position = p;
            return rid;
        }
        if (value instanceof Date) {
            OFunctionCall function = new OFunctionCall(-1);
            function.name = new OIdentifier(-1);
            function.name.value = "date";
            OExpression dateExpr = new OExpression(-1);
            dateExpr.singleQuotes = true;
            dateExpr.doubleQuotes = false;
            dateExpr.value = this.dateFormat.format(value);
            function.getParams().add(dateExpr);
            OExpression dateFormatExpr = new OExpression(-1);
            dateFormatExpr.singleQuotes = true;
            dateFormatExpr.doubleQuotes = false;
            dateFormatExpr.value = this.dateFormatString;
            function.getParams().add(dateFormatExpr);
            return function;
        }
        if (value instanceof byte[]) {
            OFunctionCall function = new OFunctionCall(-1);
            function.name = new OIdentifier(-1);
            function.name.value = "decode";
            OExpression valueExpr = new OExpression(-1);
            valueExpr.singleQuotes = true;
            valueExpr.doubleQuotes = false;
            valueExpr.value = OBase64Utils.encodeBytes((byte[])value);
            function.getParams().add(valueExpr);
            OExpression dateFormatExpr = new OExpression(-1);
            dateFormatExpr.singleQuotes = true;
            dateFormatExpr.doubleQuotes = false;
            dateFormatExpr.value = "base64";
            function.getParams().add(dateFormatExpr);
            return function;
        }
        if (value.getClass().isEnum()) {
            return value.toString();
        }
        return this;
    }
}

