/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ODirtyManager {
    private ODirtyManager overrider;
    private Map<ODocument, List<OIdentifiable>> references;
    private Set<ORecord> newRecords;
    private Set<ORecord> updateRecords;

    public void setDirty(ORecord record) {
        ODirtyManager real = this.getReal();
        if (record.getIdentity().isNew() && !record.getIdentity().isTemporary()) {
            if (real.newRecords == null) {
                real.newRecords = Collections.newSetFromMap(new IdentityHashMap());
            }
            real.newRecords.add(record);
        } else {
            if (real.updateRecords == null) {
                real.updateRecords = Collections.newSetFromMap(new IdentityHashMap());
            }
            real.updateRecords.add(record);
        }
    }

    public ODirtyManager getReal() {
        ODirtyManager real = this;
        while (real.overrider != null) {
            real = real.overrider;
        }
        if (this.overrider != null && this.overrider != real) {
            this.overrider = real;
        }
        return real;
    }

    public Set<ORecord> getNewRecords() {
        return this.getReal().newRecords;
    }

    public Set<ORecord> getUpdateRecords() {
        return this.getReal().updateRecords;
    }

    public Map<ODocument, List<OIdentifiable>> getReferences() {
        return this.getReal().references;
    }

    public boolean isSame(ODirtyManager other) {
        return this.getReal() == other.getReal();
    }

    public void merge(ODirtyManager toMerge) {
        if (this.isSame(toMerge)) {
            return;
        }
        this.newRecords = ODirtyManager.mergeSet(this.newRecords, toMerge.getNewRecords());
        this.updateRecords = ODirtyManager.mergeSet(this.updateRecords, toMerge.getUpdateRecords());
        if (toMerge.getReferences() != null) {
            if (this.references == null) {
                this.references = new IdentityHashMap<ODocument, List<OIdentifiable>>();
            }
            for (Map.Entry<ODocument, List<OIdentifiable>> entry : toMerge.getReferences().entrySet()) {
                List<OIdentifiable> refs = this.references.get(entry.getKey());
                if (refs == null) {
                    this.references.put(entry.getKey(), entry.getValue());
                    continue;
                }
                refs.addAll((Collection<OIdentifiable>)entry.getValue());
            }
        }
        toMerge.override(this);
    }

    private static Set<ORecord> mergeSet(Set<ORecord> target, Set<ORecord> source) {
        if (source != null) {
            if (target == null) {
                return source;
            }
            if (target.size() > source.size()) {
                target.addAll(source);
                return target;
            }
            source.addAll(target);
            return source;
        }
        return target;
    }

    public void track(ORecord pointing, OIdentifiable pointed) {
        this.getReal().internalTrack(pointing, pointed);
    }

    public void unTrack(ORecord pointing, OIdentifiable pointed) {
        this.getReal().internalUnTrack(pointing, pointed);
    }

    private void internalUnTrack(ORecord pointing, OIdentifiable pointed) {
        if (this.references == null) {
            return;
        }
        if (pointed.getIdentity().isNew()) {
            List<OIdentifiable> refs = this.references.get(pointing);
            if (refs == null) {
                return;
            }
            if (!(pointed instanceof ODocument) || !((ODocument)pointed).isEmbedded()) {
                refs.remove(pointed);
            }
        }
    }

    private void internalTrack(ORecord pointing, OIdentifiable pointed) {
        if (pointing instanceof ODocument && ((ODocument)pointing).isEmbedded()) {
            ORecordElement ele;
            for (ele = pointing.getOwner(); !(ele instanceof ODocument) && ele != null && ele.getOwner() != null; ele = ele.getOwner()) {
            }
            if (ele != null) {
                pointing = (ORecord)ele;
            }
        }
        if (pointed.getIdentity().isNew()) {
            List<OIdentifiable> point;
            if (!(pointed instanceof ODocument) || !((ODocument)pointed).isEmbedded()) {
                List<OIdentifiable> refs;
                if (this.references == null) {
                    this.references = new IdentityHashMap<ODocument, List<OIdentifiable>>();
                }
                if ((refs = this.references.get(pointing)) == null) {
                    refs = new ArrayList<OIdentifiable>();
                    this.references.put((ODocument)pointing, refs);
                }
                refs.add(pointed);
            } else if (pointed instanceof ODocument && (point = ORecordInternal.getDirtyManager((ORecord)pointed).getPointed((ORecord)pointed)) != null && point.size() > 0) {
                List<OIdentifiable> refs;
                if (this.references == null) {
                    this.references = new IdentityHashMap<ODocument, List<OIdentifiable>>();
                }
                if ((refs = this.references.get(pointing)) == null) {
                    refs = new ArrayList<OIdentifiable>();
                    this.references.put((ODocument)pointing, refs);
                }
                for (OIdentifiable embPoint : point) {
                    refs.add(embPoint);
                }
            }
        }
        if (pointed instanceof ORecord) {
            ORecordInternal.setDirtyManager((ORecord)pointed, this);
        }
    }

    private void override(ODirtyManager oDirtyManager) {
        ODirtyManager real = this.getReal();
        if (real == (oDirtyManager = oDirtyManager.getReal())) {
            return;
        }
        real.overrider = oDirtyManager;
        real.newRecords = null;
        real.updateRecords = null;
        real.references = null;
    }

    public void clearForSave() {
        ODirtyManager real = this.getReal();
        real.newRecords = null;
        real.updateRecords = null;
    }

    public List<OIdentifiable> getPointed(ORecord rec) {
        ODirtyManager real = this.getReal();
        if (real.references == null) {
            return null;
        }
        return real.references.get(rec);
    }

    public void removeNew(ORecord record) {
        ODirtyManager real = this.getReal();
        if (real.newRecords != null) {
            real.newRecords.remove(record);
        }
    }

    public void removePointed(ORecord record) {
        ODirtyManager real = this.getReal();
        if (real.references != null) {
            real.references.remove(record);
            if (real.references.size() == 0) {
                this.references = null;
            }
        }
    }

    public void clear() {
        this.clearForSave();
        this.getReal().references = null;
    }
}

