/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandExecutorNotFoundException;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.script.OCommandExecutorScript;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLLiveSelect;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLResultsetDelegate;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLResultset;
import com.orientechnologies.orient.core.sql.query.OLiveQuery;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLNonBlockingQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.HashMap;
import java.util.Map;

public class OCommandManager {
    private static OCommandManager instance = new OCommandManager();
    private Map<String, Class<? extends OCommandRequest>> commandRequesters = new HashMap<String, Class<? extends OCommandRequest>>();
    private Map<Class<? extends OCommandRequest>, OCallable<Void, OCommandRequest>> configCallbacks = new HashMap<Class<? extends OCommandRequest>, OCallable<Void, OCommandRequest>>();
    private Map<Class<? extends OCommandRequest>, Class<? extends OCommandExecutor>> commandReqExecMap = new HashMap<Class<? extends OCommandRequest>, Class<? extends OCommandExecutor>>();

    protected OCommandManager() {
        this.registerRequester("sql", OCommandSQL.class);
        this.registerRequester("script", OCommandScript.class);
        this.registerExecutor(OSQLAsynchQuery.class, OCommandExecutorSQLDelegate.class);
        this.registerExecutor(OSQLSynchQuery.class, OCommandExecutorSQLDelegate.class);
        this.registerExecutor(OSQLNonBlockingQuery.class, OCommandExecutorSQLDelegate.class);
        this.registerExecutor(OLiveQuery.class, OCommandExecutorSQLLiveSelect.class);
        this.registerExecutor(OCommandSQL.class, OCommandExecutorSQLDelegate.class);
        this.registerExecutor(OCommandSQLResultset.class, OCommandExecutorSQLResultsetDelegate.class);
        this.registerExecutor(OCommandScript.class, OCommandExecutorScript.class);
    }

    public static OCommandManager instance() {
        return instance;
    }

    public OCommandManager registerRequester(String iType, Class<? extends OCommandRequest> iRequest) {
        this.commandRequesters.put(iType, iRequest);
        return this;
    }

    public boolean existsRequester(String iType) {
        return this.commandRequesters.containsKey(iType);
    }

    public OCommandRequest getRequester(String iType) {
        Class<? extends OCommandRequest> reqClass = this.commandRequesters.get(iType);
        if (reqClass == null) {
            throw new IllegalArgumentException("Cannot find a command requester for type: " + iType);
        }
        try {
            return reqClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot create the command requester of class " + reqClass + " for type: " + iType, e);
        }
    }

    public OCommandManager registerExecutor(Class<? extends OCommandRequest> iRequest, Class<? extends OCommandExecutor> iExecutor, OCallable<Void, OCommandRequest> iConfigCallback) {
        this.registerExecutor(iRequest, iExecutor);
        this.configCallbacks.put(iRequest, iConfigCallback);
        return this;
    }

    public OCommandManager registerExecutor(Class<? extends OCommandRequest> iRequest, Class<? extends OCommandExecutor> iExecutor) {
        this.commandReqExecMap.put(iRequest, iExecutor);
        return this;
    }

    public OCommandManager unregisterExecutor(Class<? extends OCommandRequest> iRequest) {
        this.commandReqExecMap.remove(iRequest);
        this.configCallbacks.remove(iRequest);
        return this;
    }

    public OCommandExecutor getExecutor(OCommandRequestInternal iCommand) {
        Class<? extends OCommandExecutor> executorClass = this.commandReqExecMap.get(iCommand.getClass());
        if (executorClass == null) {
            throw new OCommandExecutorNotFoundException("Cannot find a command executor for the command request: " + iCommand);
        }
        try {
            OCommandExecutor exec = executorClass.newInstance();
            OCallable<Void, OCommandRequest> callback = this.configCallbacks.get(iCommand.getClass());
            if (callback != null) {
                callback.call(iCommand);
            }
            return exec;
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Cannot create the command executor of class " + executorClass + " for the command request: " + iCommand), e);
        }
    }
}

