/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"})
public class OPartitionedObjectPool<T>
extends OOrientListenerAbstract {
    private static final int HASH_INCREMENT = 1640531527;
    private static final int MIN_POOL_SIZE = 2;
    private static final AtomicInteger nextHashCode = new AtomicInteger();
    private final int maxPartitions;
    private final ObjectFactory<T> factory;
    private final int maxSize;
    private volatile ThreadLocal<Integer> threadHashCode = new ThreadHashCodeThreadLocal();
    private final AtomicBoolean poolBusy = new AtomicBoolean();
    private volatile PoolPartition[] partitions;
    private volatile boolean closed = false;

    public OPartitionedObjectPool(ObjectFactory factory, int maxSize, int maxPartitions) {
        this.factory = factory;
        this.maxSize = maxSize;
        this.maxPartitions = maxPartitions;
        PoolPartition[] pts = new PoolPartition[maxPartitions < 2 ? maxPartitions : 2];
        for (int i = 0; i < pts.length; ++i) {
            PoolPartition partition;
            pts[i] = partition = new PoolPartition();
            this.initQueue(partition);
        }
        this.partitions = pts;
        Orient.instance().registerWeakOrientStartupListener(this);
        Orient.instance().registerWeakOrientShutdownListener(this);
    }

    public PoolEntry<T> acquire() {
        Object object;
        PoolPartition partition;
        this.checkForClose();
        int th = this.threadHashCode.get();
        while (true) {
            int index;
            PoolPartition[] pts;
            if ((partition = (pts = this.partitions)[index = pts.length - 1 & th]) == null) {
                if (this.poolBusy.get() || !this.poolBusy.compareAndSet(false, true)) continue;
                if (pts == this.partitions && (partition = pts[index]) == null) {
                    partition = new PoolPartition();
                    this.initQueue(partition);
                    pts[index] = partition;
                }
                this.poolBusy.set(false);
                continue;
            }
            object = partition.queue.poll();
            if (object == null) {
                if (pts.length < this.maxPartitions) {
                    if (this.poolBusy.get() || !this.poolBusy.compareAndSet(false, true)) continue;
                    if (pts == this.partitions) {
                        PoolPartition[] newPartitions = new PoolPartition[pts.length << 1];
                        System.arraycopy(pts, 0, newPartitions, 0, pts.length);
                        this.partitions = newPartitions;
                    }
                    this.poolBusy.set(false);
                    continue;
                }
                if (partition.currentSize.get() >= this.maxSize) {
                    throw new IllegalStateException("You have reached maximum pool size for given partition");
                }
                object = this.factory.create();
                partition.acquiredObjects.incrementAndGet();
                partition.currentSize.incrementAndGet();
                return new PoolEntry(partition, object);
            }
            if (this.factory.isValid(object)) break;
            this.factory.close(object);
            partition.currentSize.decrementAndGet();
        }
        this.factory.init(object);
        partition.acquiredObjects.incrementAndGet();
        return new PoolEntry(partition, object);
    }

    public void release(PoolEntry<T> entry) {
        PoolPartition partition = ((PoolEntry)entry).partition;
        partition.queue.offer(entry.object);
        partition.acquiredObjects.decrementAndGet();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (PoolPartition partition : this.partitions) {
            if (partition == null) continue;
            ConcurrentLinkedQueue queue = partition.queue;
            while (!queue.isEmpty()) {
                Object object = queue.poll();
                this.factory.close(object);
            }
        }
        this.threadHashCode = null;
        this.partitions = null;
    }

    @Override
    public void onShutdown() {
        this.close();
    }

    @Override
    public void onStartup() {
        if (this.threadHashCode == null) {
            this.threadHashCode = new ThreadHashCodeThreadLocal();
        }
    }

    public int getAvailableObjects() {
        this.checkForClose();
        int result = 0;
        for (PoolPartition partition : this.partitions) {
            if (partition == null) continue;
            result += partition.currentSize.get() - partition.acquiredObjects.get();
        }
        if (result < 0) {
            return 0;
        }
        return result;
    }

    public int getCreatedInstances() {
        this.checkForClose();
        int result = 0;
        for (PoolPartition partition : this.partitions) {
            if (partition == null) continue;
            result += partition.currentSize.get();
        }
        return result;
    }

    private void initQueue(PoolPartition<T> partition) {
        ConcurrentLinkedQueue queue = ((PoolPartition)partition).queue;
        for (int n = 0; n < 2; ++n) {
            T object = this.factory.create();
            queue.add(object);
        }
        ((PoolPartition)partition).currentSize.addAndGet(2);
    }

    private void checkForClose() {
        if (this.closed) {
            throw new IllegalStateException("Pool is closed");
        }
    }

    private static int nextHashCode() {
        return nextHashCode.getAndAdd(1640531527);
    }

    private static class ThreadHashCodeThreadLocal
    extends ThreadLocal<Integer> {
        private ThreadHashCodeThreadLocal() {
        }

        @Override
        protected Integer initialValue() {
            return OPartitionedObjectPool.nextHashCode();
        }
    }

    public static final class PoolEntry<T> {
        private final PoolPartition<T> partition;
        public final T object;

        public PoolEntry(PoolPartition<T> partition, T object) {
            this.partition = partition;
            this.object = object;
        }
    }

    public static interface ObjectFactory<T> {
        public T create();

        public void init(T var1);

        public void close(T var1);

        public boolean isValid(T var1);
    }

    private static final class PoolPartition<T> {
        private final AtomicInteger currentSize = new AtomicInteger();
        private final AtomicInteger acquiredObjects = new AtomicInteger();
        private final ConcurrentLinkedQueue<T> queue = new ConcurrentLinkedQueue();

        private PoolPartition() {
        }
    }
}

