/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.karaf;

import java.io.File;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import org.apache.felix.utils.properties.Properties;
import org.apache.karaf.main.lock.Lock;

public class NexusFileLock
implements Lock {
    private final String dataDir;
    private final File file;
    private FileLock lock;
    private RandomAccessFile lockFile;

    public NexusFileLock(Properties properties) {
        if (properties == null) {
            throw new NullPointerException();
        }
        this.dataDir = properties.getProperty("karaf.data");
        this.file = new File(this.dataDir, "lock");
    }

    public synchronized boolean isAlive() {
        return this.lock != null && this.lock.isValid() && this.file.exists();
    }

    public synchronized boolean lock() {
        if (!this.doLock()) {
            System.err.println("Nexus data directory already in use: " + this.dataDir);
            System.exit(-1);
        }
        return true;
    }

    private boolean doLock() {
        if (this.lock != null) {
            return true;
        }
        try {
            try {
                this.lockFile = new RandomAccessFile(this.file, "rws");
                this.lock = this.lockFile.getChannel().tryLock(0L, 1L, false);
                if (this.lock != null) {
                    byte[] payload = ManagementFactory.getRuntimeMXBean().getName().getBytes("UTF-8");
                    this.lockFile.setLength(0L);
                    this.lockFile.seek(0L);
                    this.lockFile.write(payload);
                }
            }
            catch (Exception e) {
                System.err.println("Failed to write lock file: " + this.file.getAbsolutePath());
                e.printStackTrace();
                this.lock = null;
                if (this.lock == null) {
                    this.release();
                    return false;
                }
            }
        }
        finally {
            if (this.lock == null) {
                this.release();
                return false;
            }
        }
        return true;
    }

    public synchronized void release() {
        if (this.lock != null) {
            try {
                this.lock.close();
            }
            catch (Exception exception) {}
            this.lock = null;
        }
        if (this.lockFile != null) {
            try {
                this.lockFile.close();
            }
            catch (Exception exception) {}
            this.lockFile = null;
        }
    }
}

