/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis.handlers;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityUUID;

public class EntityUUIDTypeHandler
extends BaseTypeHandler<EntityId> {
    private final boolean lenient;

    public EntityUUIDTypeHandler(boolean lenient) {
        this.lenient = lenient;
    }

    public void setNonNullParameter(PreparedStatement ps, int parameterIndex, EntityId parameter, JdbcType jdbcType) throws SQLException {
        UUID uuid = parameter instanceof EntityUUID ? ((EntityUUID)parameter).uuid() : UUID.fromString(parameter.getValue());
        if (this.lenient) {
            ps.setString(parameterIndex, uuid.toString());
        } else {
            ps.setObject(parameterIndex, uuid);
        }
    }

    public EntityUUID getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.nullableEntityUUID(rs.getObject(columnName));
    }

    public EntityUUID getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.nullableEntityUUID(rs.getObject(columnIndex));
    }

    public EntityUUID getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.nullableEntityUUID(cs.getObject(columnIndex));
    }

    @Nullable
    private EntityUUID nullableEntityUUID(@Nullable Object uuid) {
        if (uuid instanceof UUID) {
            return new EntityUUID((UUID)uuid);
        }
        if (uuid instanceof String) {
            return new EntityUUID(UUID.fromString((String)uuid));
        }
        return null;
    }
}

