/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis.handlers;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import java.nio.charset.StandardCharsets;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.sonatype.nexus.datastore.mybatis.CipherAwareTypeHandler;

public class EncryptedStringTypeHandler
extends CipherAwareTypeHandler<String> {
    private static final Base64Variant BASE_64 = Base64Variants.getDefaultVariant();

    public final void setNonNullParameter(PreparedStatement ps, int parameterIndex, String parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(parameterIndex, this.encrypt(parameter));
    }

    public final String getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.decrypt(rs.getString(columnName));
    }

    public final String getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.decrypt(rs.getString(columnIndex));
    }

    public final String getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.decrypt(cs.getString(columnIndex));
    }

    private String encrypt(String value) {
        return BASE_64.encode(this.cipher().encrypt(value.getBytes(StandardCharsets.UTF_8)));
    }

    private String decrypt(String value) {
        return value != null ? new String(this.cipher().decrypt(BASE_64.decode(value)), StandardCharsets.UTF_8) : null;
    }
}

