/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserDelegate;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.function.Predicate;
import org.sonatype.nexus.security.PasswordHelper;

final class SensitiveJsonParser
extends JsonParserDelegate {
    private final PasswordHelper passwordHelper;
    private final Predicate<String> attributeFilter;

    SensitiveJsonParser(JsonParser delegate, PasswordHelper passwordHelper, Predicate<String> atributeFilter) {
        super(delegate);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
        this.attributeFilter = (Predicate)Preconditions.checkNotNull(atributeFilter);
    }

    public String getText() throws IOException {
        String text = super.getText();
        if (text != null && this.currentToken() == JsonToken.VALUE_STRING && this.isSensitiveAttribute()) {
            text = this.passwordHelper.decrypt(text);
        }
        return text;
    }

    private boolean isSensitiveAttribute() {
        String attributName = this.getParsingContext().getCurrentName();
        return attributName != null && this.attributeFilter.test(attributName);
    }
}

