/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.util.JsonGeneratorDelegate;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.function.Predicate;
import org.sonatype.nexus.security.PasswordHelper;

final class SensitiveJsonGenerator
extends JsonGeneratorDelegate {
    private final PasswordHelper passwordHelper;
    private final Predicate<String> attributeFilter;

    SensitiveJsonGenerator(JsonGenerator delegate, PasswordHelper passwordHelper, Predicate<String> attributeFilter) {
        super(delegate, false);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
        this.attributeFilter = (Predicate)Preconditions.checkNotNull(attributeFilter);
    }

    public void writeString(String text) throws IOException {
        if (text != null && this.isSensitiveAttribute()) {
            super.writeString(this.passwordHelper.encrypt(text));
        } else {
            super.writeString(text);
        }
    }

    public void writeString(SerializableString text) throws IOException {
        if (text != null && this.isSensitiveAttribute()) {
            super.writeString(this.passwordHelper.encrypt(text.getValue()));
        } else {
            super.writeString(text);
        }
    }

    public void writeString(char[] text, int offset, int length) throws IOException {
        if (text != null && this.isSensitiveAttribute()) {
            super.writeString(this.passwordHelper.encryptChars(text, offset, length));
        } else {
            super.writeString(text, offset, length);
        }
    }

    private boolean isSensitiveAttribute() {
        String attributeName = this.getOutputContext().getCurrentName();
        return attributeName != null && this.attributeFilter.test(attributeName);
    }
}

