/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.ibatis.session.Configuration;
import org.sonatype.nexus.common.text.Strings2;

final class SensitiveAttributes {
    private static final String SENSITIVE_ATTRIBUTES_KEY = "sensitiveAttributes";
    private static final Predicate<String> SENSITIVE_FILTER = Pattern.compile("(?i)(password|secret)").asPredicate();

    private SensitiveAttributes() {
    }

    public static Predicate<String> buildSensitiveAttributeFilter(Configuration config) {
        String additionalAttributes = config.getVariables().getProperty(SENSITIVE_ATTRIBUTES_KEY);
        if (Strings2.isBlank((String)additionalAttributes)) {
            return SENSITIVE_FILTER;
        }
        Predicate<String> additionalFilter = arg_0 -> ((ImmutableSet)ImmutableSet.copyOf((Iterable)Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)additionalAttributes))).contains(arg_0);
        return SENSITIVE_FILTER.or(additionalFilter);
    }
}

