/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.Hidden;
import org.eclipse.sisu.Typed;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.crypto.PbeCipherFactory;
import org.sonatype.nexus.crypto.internal.CryptoHelperImpl;
import org.sonatype.nexus.crypto.internal.PbeCipherFactoryImpl;

@Named(value="mybatis")
@Singleton
@Typed(value={PbeCipherFactory.PbeCipher.class})
@Hidden
final class MyBatisCipher
implements PbeCipherFactory.PbeCipher {
    private PbeCipherFactory.PbeCipher pbeCipher;

    @Inject
    MyBatisCipher(PbeCipherFactory pbeCipherFactory, @Named(value="${nexus.mybatis.cipher.password:-changeme}") String password, @Named(value="${nexus.mybatis.cipher.salt:-changeme}") String salt, @Named(value="${nexus.mybatis.cipher.iv:-0123456789ABCDEF}") String iv) throws Exception {
        this.pbeCipher = pbeCipherFactory.create(password, salt, iv);
    }

    @VisibleForTesting
    MyBatisCipher() throws Exception {
        this((PbeCipherFactory)new PbeCipherFactoryImpl((CryptoHelper)new CryptoHelperImpl()), "changeme", "changeme", "0123456789ABCDEF");
    }

    public byte[] encrypt(byte[] bytes) {
        return this.pbeCipher.encrypt(bytes);
    }

    public byte[] decrypt(byte[] bytes) {
        return this.pbeCipher.decrypt(bytes);
    }
}

