/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.datastore.mybatis;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.FrozenException;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.common.entity.EntityUUID;
import org.sonatype.nexus.common.entity.HasEntityId;
import org.sonatype.nexus.datastore.api.DuplicateKeyException;
import org.sonatype.nexus.datastore.mybatis.CombUUID;

final class EntityExecutor
implements Executor {
    private static final Logger log = LoggerFactory.getLogger(EntityExecutor.class);
    private final Executor delegate;
    private final AtomicBoolean frozen;
    @Nullable
    private List<HasEntityId> generatedEntityIds;

    public EntityExecutor(Executor delegate, AtomicBoolean frozen) {
        this.delegate = (Executor)Preconditions.checkNotNull((Object)delegate);
        this.frozen = (AtomicBoolean)Preconditions.checkNotNull((Object)frozen);
    }

    public int update(MappedStatement ms, Object parameter) throws SQLException {
        SqlCommandType commandType = ms.getSqlCommandType();
        if (commandType != SqlCommandType.SELECT && this.frozen.get()) {
            log.debug("Disallowing {} because the application is frozen", (Object)commandType);
            throw new FrozenException(commandType + " is not allowed while the application is frozen");
        }
        if (commandType == SqlCommandType.INSERT && parameter instanceof HasEntityId) {
            this.generateEntityId((HasEntityId)parameter);
        }
        try {
            return this.delegate.update(ms, parameter);
        }
        catch (SQLException e) {
            switch (e.getSQLState()) {
                case "23505": {
                    throw new DuplicateKeyException((Throwable)e);
                }
            }
            throw e;
        }
    }

    public <E> List<E> query(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, CacheKey cacheKey, BoundSql boundSql) throws SQLException {
        return this.delegate.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
    }

    public <E> List<E> query(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler) throws SQLException {
        return this.delegate.query(ms, parameter, rowBounds, resultHandler);
    }

    public <E> Cursor<E> queryCursor(MappedStatement ms, Object parameter, RowBounds rowBounds) throws SQLException {
        return this.delegate.queryCursor(ms, parameter, rowBounds);
    }

    public List<BatchResult> flushStatements() throws SQLException {
        return this.delegate.flushStatements();
    }

    public void commit(boolean required) throws SQLException {
        try {
            this.delegate.commit(required);
            this.commitEntityIds();
        }
        catch (Error | RuntimeException | SQLException e) {
            this.rollbackEntityIds();
            throw e;
        }
    }

    public void rollback(boolean required) throws SQLException {
        this.rollbackEntityIds();
        this.delegate.rollback(required);
    }

    public CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds, BoundSql boundSql) {
        return this.delegate.createCacheKey(ms, parameterObject, rowBounds, boundSql);
    }

    public boolean isCached(MappedStatement ms, CacheKey key) {
        return this.delegate.isCached(ms, key);
    }

    public void clearLocalCache() {
        this.delegate.clearLocalCache();
    }

    public void deferLoad(MappedStatement ms, MetaObject resultObject, String property, CacheKey key, Class<?> targetType) {
        this.delegate.deferLoad(ms, resultObject, property, key, targetType);
    }

    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    public void close(boolean forceRollback) {
        if (forceRollback) {
            this.rollbackEntityIds();
        }
        this.delegate.close(forceRollback);
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public void setExecutorWrapper(Executor executor) {
        this.delegate.setExecutorWrapper(executor);
    }

    private void generateEntityId(HasEntityId entity) {
        Preconditions.checkState((entity.getId() == null ? 1 : 0) != 0, (Object)"Entity already has an id");
        entity.setId((EntityId)new EntityUUID(CombUUID.combUUID()));
        if (this.generatedEntityIds == null) {
            this.generatedEntityIds = new ArrayList<HasEntityId>();
        }
        this.generatedEntityIds.add(entity);
    }

    private void commitEntityIds() {
        this.generatedEntityIds = null;
    }

    private void rollbackEntityIds() {
        if (this.generatedEntityIds != null) {
            this.generatedEntityIds.forEach(HasEntityId::clearId);
            this.generatedEntityIds = null;
        }
    }
}

