/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.proui.internal;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.sisu.Priority;
import org.eclipse.sisu.space.ClassSpace;
import org.sonatype.nexus.ui.UiPluginDescriptor;
import org.sonatype.nexus.ui.UiUtil;

@Named
@Singleton
@Priority(value=2147483547)
public class ProUiReactPluginDescriptor
implements UiPluginDescriptor {
    private final List<String> scripts;
    private final List<String> debugScripts;
    private final List<String> styles;

    @Inject
    public ProUiReactPluginDescriptor(ClassSpace space) {
        this.scripts = Arrays.asList(UiUtil.getPathForFile((String)"nexus-proui-bundle.js", (ClassSpace)space));
        this.debugScripts = Arrays.asList(UiUtil.getPathForFile((String)"nexus-proui-bundle.debug.js", (ClassSpace)space));
        this.styles = Arrays.asList(UiUtil.getPathForFile((String)"nexus-proui-bundle.css", (ClassSpace)space));
    }

    public String getName() {
        return "nexus-proui-plugin";
    }

    @Nullable
    public List<String> getScripts(boolean isDebug) {
        return isDebug ? this.debugScripts : this.scripts;
    }

    @Nullable
    public List<String> getStyles() {
        return this.styles;
    }
}

