/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.coreui.internal.log;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogXO {
    private final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    private String fileName = null;
    private long size = -1L;
    private long lastModified = -1L;

    public LogXO(Path path) {
        Preconditions.checkNotNull((Object)path);
        try {
            this.fileName = path.getParent().getFileName().toString().equals("tasks") ? "tasks/" + path.getFileName().toString() : path.getFileName().toString();
            this.size = Files.size(path);
            this.lastModified = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            this.log.debug(String.format("Unable to get information about log file at {%s}", path));
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getSize() {
        return this.size;
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

