/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.coreui.internal.blobstore;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.BlobStoreDescriptor;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.quota.BlobStoreQuota;
import org.sonatype.nexus.coreui.internal.blobstore.BlobStoreQuotaTypesUIResponse;
import org.sonatype.nexus.coreui.internal.blobstore.BlobStoreTypesUIResponse;
import org.sonatype.nexus.coreui.internal.blobstore.BlobStoreUIResponse;
import org.sonatype.nexus.coreui.internal.blobstore.BlobStoreUsageUIResponse;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.rest.Resource;

@Named
@Singleton
@Path(value="/internal/ui/blobstores")
public class BlobStoreUIResource
extends ComponentSupport
implements Resource {
    static final String RESOURCE_PATH = "/internal/ui/blobstores";
    private final BlobStoreManager blobStoreManager;
    private final Map<String, BlobStoreDescriptor> blobStoreDescriptors;
    private final List<BlobStoreQuotaTypesUIResponse> blobStoreQuotaTypes;
    private final RepositoryManager repositoryManager;

    @Inject
    public BlobStoreUIResource(BlobStoreManager blobStoreManager, Map<String, BlobStoreDescriptor> blobStoreDescriptors, Map<String, BlobStoreQuota> quotaFactories, RepositoryManager repositoryManager) {
        this.blobStoreManager = (BlobStoreManager)Preconditions.checkNotNull((Object)blobStoreManager);
        this.blobStoreDescriptors = (Map)Preconditions.checkNotNull(blobStoreDescriptors);
        this.blobStoreQuotaTypes = quotaFactories.entrySet().stream().map(BlobStoreQuotaTypesUIResponse::new).collect(Collectors.toList());
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    public List<BlobStoreUIResponse> listBlobStores() {
        return Streams.stream((Iterable)this.blobStoreManager.browse()).map(blobStore -> {
            String typeId = this.blobStoreDescriptors.get(blobStore.getBlobStoreConfiguration().getType()).getId();
            return new BlobStoreUIResponse(typeId, (BlobStore)blobStore);
        }).collect(Collectors.toList());
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    @Path(value="/types")
    public List<BlobStoreTypesUIResponse> listBlobStoreTypes() {
        return this.blobStoreDescriptors.entrySet().stream().filter(entry -> ((BlobStoreDescriptor)entry.getValue()).isEnabled()).map(BlobStoreTypesUIResponse::new).collect(Collectors.toList());
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    @Path(value="/usage/{name}")
    public BlobStoreUsageUIResponse getBlobStoreUsage(@PathParam(value="name") String name) {
        long repositoryUsage = this.repositoryManager.blobstoreUsageCount(name);
        long blobStoreUsage = this.blobStoreManager.blobStoreUsageCount(name);
        return new BlobStoreUsageUIResponse(repositoryUsage, blobStoreUsage);
    }

    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:blobstores:read"})
    @GET
    @Path(value="/quotaTypes")
    public List<BlobStoreQuotaTypesUIResponse> listQuotaTypes() {
        return this.blobStoreQuotaTypes;
    }
}

