/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.siesta.internal.resteasy;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Path;
import javax.ws.rs.ext.RuntimeDelegate;
import org.eclipse.sisu.BeanEntry;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.siesta.ComponentContainer;
import org.sonatype.nexus.siesta.SiestaResourceMethodFinder;
import org.sonatype.nexus.siesta.internal.resteasy.NotCacheableResponseFilter;
import org.sonatype.nexus.siesta.internal.resteasy.SisuResourceFactory;
import org.sonatype.nexus.siesta.internal.resteasy.SisuResteasyDeployment;
import org.sonatype.nexus.siesta.internal.resteasy.SisuResteasyProviderFactory;

public class ComponentContainerImpl
extends HttpServletDispatcher
implements ComponentContainer {
    private static final Logger log = LoggerFactory.getLogger(ComponentContainerImpl.class);
    private final transient ResteasyDeployment deployment = new SisuResteasyDeployment();

    public ComponentContainerImpl() {
        RuntimeDelegate.setInstance((RuntimeDelegate)((RuntimeDelegate)Preconditions.checkNotNull((Object)this.deployment.getProviderFactory())));
    }

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ResteasyProviderFactory.class.getClassLoader());
            this.doInit(servletConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private void doInit(ServletConfig servletConfig) throws ServletException {
        this.deployment.start();
        servletConfig.getServletContext().setAttribute(ResteasyDeployment.class.getName(), (Object)this.deployment);
        servletConfig.getServletContext().setAttribute(SiestaResourceMethodFinder.class.getName(), (Object)new SiestaResourceMethodFinder(this, this.deployment));
        super.init(servletConfig);
        ResteasyProviderFactory providerFactory = this.getDispatcher().getProviderFactory();
        providerFactory.getContainerResponseFilterRegistry().registerClass(NotCacheableResponseFilter.class);
        if (log.isDebugEnabled()) {
            log.debug("Provider factory: {}", (Object)providerFactory);
            log.debug("Configuration: {}", (Object)providerFactory.getConfiguration());
            log.debug("Runtime type: {}", (Object)providerFactory.getRuntimeType());
            log.debug("Built-ins registered: {}", (Object)providerFactory.isBuiltinsRegistered());
            log.debug("Properties: {}", (Object)providerFactory.getProperties());
            log.debug("Dynamic features: {}", (Object)providerFactory.getServerDynamicFeatures());
            log.debug("Enabled features: {}", (Object)providerFactory.getEnabledFeatures());
            log.debug("Class contracts: {}", (Object)providerFactory.getClassContracts());
            log.debug("Reader interceptor registry: {}", (Object)providerFactory.getServerReaderInterceptorRegistry());
            log.debug("Writer interceptor registry: {}", (Object)providerFactory.getServerWriterInterceptorRegistry());
            log.debug("Injector factory: {}", (Object)providerFactory.getInjectorFactory());
            log.debug("Instances: {}", (Object)providerFactory.getInstances());
            log.debug("Exception mappers: {}", (Object)providerFactory.getExceptionMappers());
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.deployment.stop();
    }

    @Override
    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.service(request, response);
    }

    private static boolean isResource(Class<?> type) {
        return Resource.class.isAssignableFrom(type);
    }

    @Nullable
    private static String resourcePath(Class<?> type) {
        Path path = type.getAnnotation(Path.class);
        if (path != null) {
            return path.value();
        }
        return null;
    }

    @Override
    public void addComponent(BeanEntry<?, ?> entry) throws Exception {
        Class type = entry.getImplementationClass();
        if (ComponentContainerImpl.isResource(type)) {
            this.getDispatcher().getRegistry().addResourceFactory((ResourceFactory)new SisuResourceFactory(entry));
            String path = ComponentContainerImpl.resourcePath(type);
            if (path == null) {
                log.warn("Found resource implementation missing @Path: {}", (Object)type.getName());
            } else {
                log.debug("Added resource: {} with path: {}", (Object)type.getName(), (Object)path);
            }
        } else {
            this.getDispatcher().getProviderFactory().register(entry.getValue());
            log.debug("Added component: {}", (Object)type.getName());
        }
    }

    @Override
    public void removeComponent(BeanEntry<?, ?> entry) throws Exception {
        Class type = entry.getImplementationClass();
        if (ComponentContainerImpl.isResource(type)) {
            this.getDispatcher().getRegistry().removeRegistrations(type);
            String path = ComponentContainerImpl.resourcePath(type);
            log.debug("Removed resource: {} with path: {}", (Object)type.getName(), (Object)path);
        } else {
            ResteasyProviderFactory providerFactory = this.getDispatcher().getProviderFactory();
            if (providerFactory instanceof SisuResteasyProviderFactory) {
                ((SisuResteasyProviderFactory)providerFactory).removeRegistrations(type);
                log.debug("Removed component: {}", (Object)type.getName());
            } else {
                log.warn("Component removal not supported; Unable to remove component: {}", (Object)type.getName());
            }
        }
    }
}

