/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.siesta;

import com.google.common.base.Preconditions;
import com.google.inject.Key;
import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ext.RuntimeDelegate;
import org.eclipse.sisu.BeanEntry;
import org.eclipse.sisu.Mediator;
import org.eclipse.sisu.inject.BeanLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.sonatype.nexus.rest.Component;
import org.sonatype.nexus.siesta.ComponentContainer;

@Named
@Singleton
public class SiestaServlet
extends HttpServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final BeanLocator beanLocator;
    private final ComponentContainer componentContainer;

    @Inject
    public SiestaServlet(BeanLocator beanLocator, ComponentContainer componentContainer) {
        this.beanLocator = (BeanLocator)Preconditions.checkNotNull((Object)beanLocator);
        this.componentContainer = (ComponentContainer)Preconditions.checkNotNull((Object)componentContainer);
        this.log.debug("Component container: {}", (Object)componentContainer);
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.componentContainer.init(config);
        this.log.info("JAX-RS RuntimeDelegate: {}", (Object)RuntimeDelegate.getInstance());
        this.beanLocator.watch(Key.get(Component.class), (Mediator)new ComponentMediator(), (Object)this.componentContainer);
        this.log.info("Initialized");
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Preconditions.checkNotNull((Object)request);
        Preconditions.checkNotNull((Object)response);
        String uri = request.getRequestURI();
        if (request.getQueryString() != null) {
            uri = String.format("%s?%s", uri, request.getQueryString());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing: {} {} ({})", new Object[]{request.getMethod(), uri, request.getRequestURL()});
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Context path: {}", (Object)request.getContextPath());
            this.log.trace("Servlet path: {}", (Object)request.getServletPath());
        }
        MDC.put((String)((Object)((Object)this)).getClass().getName(), (String)uri);
        try {
            this.componentContainer.service(request, response);
        }
        finally {
            MDC.remove((String)((Object)((Object)this)).getClass().getName());
        }
    }

    public void destroy() {
        this.componentContainer.destroy();
        super.destroy();
        this.log.info("Destroyed");
    }

    private class ComponentMediator
    implements Mediator<Annotation, Component, ComponentContainer> {
        private ComponentMediator() {
        }

        public void add(BeanEntry<Annotation, Component> entry, ComponentContainer container) throws Exception {
            SiestaServlet.this.log.trace("Adding component: {}", (Object)entry.getKey());
            try {
                container.addComponent(entry);
            }
            catch (Exception e) {
                SiestaServlet.this.log.error("Failed to add component", (Throwable)e);
            }
        }

        public void remove(BeanEntry<Annotation, Component> entry, ComponentContainer container) throws Exception {
            SiestaServlet.this.log.trace("Removing component: {}", (Object)entry.getKey());
            try {
                container.removeComponent(entry);
            }
            catch (Exception e) {
                SiestaServlet.this.log.error("Failed to remove component", (Throwable)e);
            }
        }
    }
}

