/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.siesta;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import java.util.Map;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.SecurityFilter;
import org.sonatype.nexus.siesta.ResteasyModule;
import org.sonatype.nexus.siesta.SiestaServlet;

@Named
@FeatureFlag(name="nexus.session.enabled")
public class SiestaModule
extends AbstractModule {
    public static final String MOUNT_POINT = "/service/rest";
    private static final Logger log = LoggerFactory.getLogger(SiestaModule.class);
    public static final String SKIP_MODULE_CONFIGURATION = String.valueOf(SiestaModule.class.getName()) + ".skip";

    protected void configure() {
        if (!Boolean.getBoolean(SKIP_MODULE_CONFIGURATION)) {
            this.doConfigure();
        }
    }

    private void doConfigure() {
        this.install((Module)new ResteasyModule());
        this.install((Module)this.configureServletModule());
        this.install(this.configureFilterChainModule());
    }

    protected ServletModule configureServletModule() {
        return new ServletModule(){

            protected void configureServlets() {
                log.debug("Mount point: {}", (Object)SiestaModule.MOUNT_POINT);
                this.bind(SiestaServlet.class);
                this.serve("/service/rest/*", new String[0]).with(SiestaServlet.class, (Map)ImmutableMap.of((Object)"resteasy.servlet.mapping.prefix", (Object)SiestaModule.MOUNT_POINT));
                this.filter("/service/rest/*", new String[0]).through(SecurityFilter.class);
            }
        };
    }

    protected Module configureFilterChainModule() {
        return new FilterChainModule(){

            protected void configure() {
                this.addFilterChain("/service/rest/**", new String[]{"nx-authc", "nx-anonymous", "nx-anticsrf-authc"});
            }
        };
    }
}

