/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.siesta;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import java.util.Map;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.JwtSecurityFilter;
import org.sonatype.nexus.siesta.SiestaModule;
import org.sonatype.nexus.siesta.SiestaServlet;

@Named
@FeatureFlag(name="nexus.jwt.enabled")
public class JwtSiestaModule
extends SiestaModule {
    private static final Logger log = LoggerFactory.getLogger(JwtSiestaModule.class);

    @Override
    protected ServletModule configureServletModule() {
        return new ServletModule(){

            protected void configureServlets() {
                log.debug("Mount point: {}", (Object)"/service/rest");
                this.bind(SiestaServlet.class);
                this.serve("/service/rest/*", new String[0]).with(SiestaServlet.class, (Map)ImmutableMap.of((Object)"resteasy.servlet.mapping.prefix", (Object)"/service/rest"));
                this.filter("/service/rest/*", new String[0]).through(JwtSecurityFilter.class);
            }
        };
    }

    @Override
    protected Module configureFilterChainModule() {
        return new FilterChainModule(){

            protected void configure() {
                this.addFilterChain("/service/rest/**", new String[]{"nx-authc", "nx-jwt", "nx-anonymous", "nx-anticsrf-authc"});
            }
        };
    }
}

