/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.search;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.rest.SearchMappings;
import org.sonatype.nexus.repository.search.event.SearchEvent;
import org.sonatype.nexus.repository.search.query.SearchFilter;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class SearchMeter
implements AnalyticsMarker,
EventAware {
    private static final String FORMAT_CRITERIA_KEY = "format";
    public static final String NEXUS_ANALYTICS_REST_SEARCH_COUNT_GAUGE_NAME = "nexus.analytics.rest_search_count";
    public static final String NEXUS_ANALYTICS_UI_SEARCH_COUNT_GAUGE_NAME = "nexus.analytics.ui_search_count";
    public static final String NEXUS_ANALYTICS_FORMAT_SEARCH_COUNT_GAUGE_NAME = "nexus.analytics.format_search_count";
    public static final String NEXUS_ANALYTICS_WILDCARD_STAR_SEARCH_COUNT_GAUGE_NAME = "nexus.analytics.wildcard_star_search_count";
    public static final String NEXUS_ANALYTICS_WILDCARD_QUESTION_MARK_SEARCH_COUNT_GAUGE_NAME = "nexus.analytics.wildcard_question_mark_search_count";
    public static final String NEXUS_ANALYTICS_QUOTED_SEARCH_COUNT_GAUGE_NAME = "nexus.analytics.quoted_search_count";
    public static final String NEXUS_ANALYTICS_NON_FORMAT_SEARCH_COUNT_GAUGE_NAME = "nexus.analytics.non_format_search_count";
    public static final String NEXUS_ANALYTICS_SEARCH_CRITERIA_COUNT = "nexus.analytics.search_criteria_count";
    public static final String NEXUS_ANALYTICS_SEARCH_CRITERIA = "nexus.analytics.search_criteria";
    private final MetricRegistry metricRegistry;
    private final List<SearchMappings> allSearchMappings;
    private final Map<String, Integer> searchFilterPropertyCount;

    @Inject
    public SearchMeter(MetricRegistry metricRegistry, List<SearchMappings> allSearchMappings) {
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry);
        this.allSearchMappings = (List)Preconditions.checkNotNull(allSearchMappings);
        this.searchFilterPropertyCount = new HashMap<String, Integer>();
    }

    @CachedGauge(name="nexus.analytics.search_criteria", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Integer> getSearchFilterProperties() {
        HashMap<String, Integer> returnValue = new HashMap<String, Integer>(this.searchFilterPropertyCount);
        this.searchFilterPropertyCount.clear();
        return returnValue;
    }

    @Subscribe
    @AllowConcurrentEvents
    public void markSearch(SearchEvent event) {
        switch (event.getSource()) {
            case UI: {
                this.metricRegistry.meter(NEXUS_ANALYTICS_UI_SEARCH_COUNT_GAUGE_NAME).mark();
                break;
            }
            case REST: {
                this.metricRegistry.meter(NEXUS_ANALYTICS_REST_SEARCH_COUNT_GAUGE_NAME).mark();
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + event.getSource());
            }
        }
        ArrayList<String> searchCriteria = new ArrayList<String>();
        event.getSearchFilters().stream().map(SearchFilter::getProperty).filter(Objects::nonNull).map(String::toLowerCase).forEach(property -> {
            Integer n = this.searchFilterPropertyCount.compute((String)property, (prop, value) -> value == null ? 1 : value + 1);
        });
        for (SearchFilter searchFilter : event.getSearchFilters()) {
            searchCriteria.add(searchFilter.getProperty());
            this.metricRegistry.meter(NEXUS_ANALYTICS_SEARCH_CRITERIA_COUNT).mark();
            String searchValue = searchFilter.getValue();
            if (searchValue == null || searchValue.isEmpty()) continue;
            if (searchValue.contains("*")) {
                this.metricRegistry.meter(NEXUS_ANALYTICS_WILDCARD_STAR_SEARCH_COUNT_GAUGE_NAME).mark();
            }
            if (searchValue.contains("\"")) {
                this.metricRegistry.meter(NEXUS_ANALYTICS_QUOTED_SEARCH_COUNT_GAUGE_NAME).mark();
            }
            if (!searchValue.contains("?")) continue;
            this.metricRegistry.meter(NEXUS_ANALYTICS_WILDCARD_QUESTION_MARK_SEARCH_COUNT_GAUGE_NAME).mark();
        }
        if (searchCriteria.stream().anyMatch(FORMAT_CRITERIA_KEY::equals)) {
            this.metricRegistry.meter(NEXUS_ANALYTICS_FORMAT_SEARCH_COUNT_GAUGE_NAME).mark();
        } else {
            this.metricRegistry.meter(NEXUS_ANALYTICS_NON_FORMAT_SEARCH_COUNT_GAUGE_NAME).mark();
        }
    }

    @Override
    public void reset() {
        this.metricRegistry.remove(NEXUS_ANALYTICS_REST_SEARCH_COUNT_GAUGE_NAME);
        this.metricRegistry.remove(NEXUS_ANALYTICS_FORMAT_SEARCH_COUNT_GAUGE_NAME);
        this.metricRegistry.remove(NEXUS_ANALYTICS_WILDCARD_STAR_SEARCH_COUNT_GAUGE_NAME);
        this.metricRegistry.remove(NEXUS_ANALYTICS_WILDCARD_QUESTION_MARK_SEARCH_COUNT_GAUGE_NAME);
        this.metricRegistry.remove(NEXUS_ANALYTICS_QUOTED_SEARCH_COUNT_GAUGE_NAME);
        this.metricRegistry.remove(NEXUS_ANALYTICS_NON_FORMAT_SEARCH_COUNT_GAUGE_NAME);
        this.metricRegistry.remove(NEXUS_ANALYTICS_UI_SEARCH_COUNT_GAUGE_NAME);
    }
}

