/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.system;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.sonatype.analytics.AnalyticsMarker;
import com.sonatype.analytics.internal.system.AzureEnvironmentService;
import com.sonatype.analytics.internal.system.GCPEnvironmentService;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class DeploymentAnalytics
extends ComponentSupport
implements AnalyticsMarker {
    private static final String KUBERNETES_INDICATOR = "KUBERNETES_SERVICE_HOST";
    private Map<String, String> environmentVariables;
    private Map<String, String> systemProperties;
    private final AzureEnvironmentService azureEnvironmentService;
    private final GCPEnvironmentService gcpEnvironmentService;

    @Inject
    public DeploymentAnalytics(AzureEnvironmentService azureEnvironmentService, GCPEnvironmentService gcpEnvironmentService) {
        this.azureEnvironmentService = (AzureEnvironmentService)((Object)Preconditions.checkNotNull((Object)((Object)azureEnvironmentService)));
        this.gcpEnvironmentService = (GCPEnvironmentService)((Object)Preconditions.checkNotNull((Object)((Object)gcpEnvironmentService)));
        this.environmentVariables = System.getenv();
        this.systemProperties = System.getProperties().entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue().toString()));
    }

    @CachedGauge(name="nexus.analytics.aws_environment", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public boolean getAwsEnvironment() {
        return this.environmentVariables.entrySet().stream().anyMatch(this.entryMatcher(this::containsAwsIndicator)) || this.systemProperties.entrySet().stream().anyMatch(this.entryMatcher(this::containsAwsIndicator));
    }

    @CachedGauge(name="nexus.analytics.azure_environment", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public boolean getAzureEnvironment() {
        return this.azureEnvironmentService.isAzureVM();
    }

    @CachedGauge(name="nexus.analytics.gcp_environment", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public boolean getGCPEnvironment() {
        return this.gcpEnvironmentService.isGCPVM();
    }

    @CachedGauge(name="nexus.analytics.kubernetes_deployment", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public boolean isKubernetesDeployment() {
        return this.environmentVariables.containsKey(KUBERNETES_INDICATOR);
    }

    private Predicate<Map.Entry<String, String>> entryMatcher(Predicate<String> predicate) {
        return entry -> {
            if (predicate.test((String)entry.getKey()) || predicate.test((String)entry.getValue())) {
                this.log.debug("AWS Indicator identified {}={}", entry.getKey(), entry.getValue());
                return true;
            }
            return false;
        };
    }

    private boolean containsAwsIndicator(String value) {
        String lowerCasedValue = value.toLowerCase();
        return lowerCasedValue.contains("aws") || lowerCasedValue.contains("amzn") || lowerCasedValue.contains("amazon");
    }
}

