/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.security;

import com.codahale.metrics.annotation.CachedGauge;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.common.graph.GraphUtil;
import org.sonatype.nexus.security.SecuritySystem;
import org.sonatype.nexus.security.authz.NoSuchAuthorizationManagerException;

@Named
@Singleton
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class RoleAnalytics
extends ComponentSupport
implements AnalyticsMarker {
    private static final String ROOT_NODE = "!!ROOT!!";
    private static final String DEPTH = "depth";
    private static final String AVG_DEPTH = "avg_depth";
    private static final String MAX_DEPTH = "max_depth";
    public static final String BREADTH = "reachable_breadth";
    public static final String AVG_BREADTH = "avg_breadth";
    public static final String MAX_BREADTH = "max_breadth";
    private final SecuritySystem securitySystem;

    @Inject
    public RoleAnalytics(SecuritySystem securitySystem) {
        this.securitySystem = (SecuritySystem)Preconditions.checkNotNull((Object)securitySystem);
    }

    @CachedGauge(name="nexus.analytics.security_roles", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Map<String, Object> getRoleAnalytics() {
        try {
            Set roles = this.securitySystem.listRoles("default");
            MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).build();
            graph.addNode((Object)ROOT_NODE);
            roles.forEach(role -> {
                graph.putEdge((Object)ROOT_NODE, (Object)role.getRoleId());
                role.getRoles().forEach(childRole -> {
                    boolean bl = graph.putEdge((Object)role.getRoleId(), childRole);
                });
            });
            HashMap roleAnalytics = new HashMap();
            roles.forEach(role -> {
                Map analytics = roleAnalytics.computeIfAbsent(role.getRoleId(), key -> new HashMap());
                analytics.put(DEPTH, GraphUtil.depth((Graph)graph, (Object)role.getRoleId(), (int)0));
                analytics.put(BREADTH, Graphs.reachableNodes((Graph)graph, (Object)role.getRoleId()).size());
            });
            ImmutableMap.Builder analytics = ImmutableMap.builder();
            analytics.put((Object)MAX_DEPTH, (Object)roleAnalytics.values().stream().mapToInt(a -> (Integer)a.get(DEPTH)).max().orElse(0));
            analytics.put((Object)AVG_DEPTH, (Object)roleAnalytics.values().stream().mapToInt(a -> (Integer)a.get(DEPTH)).average().orElse(0.0));
            analytics.put((Object)MAX_BREADTH, (Object)roleAnalytics.values().stream().mapToInt(a -> (Integer)a.get(BREADTH)).max().orElse(0));
            analytics.put((Object)AVG_BREADTH, (Object)roleAnalytics.values().stream().mapToInt(a -> (Integer)a.get(BREADTH)).average().orElse(0.0));
            analytics.put((Object)"role_count", (Object)roles.size());
            return analytics.build();
        }
        catch (NoSuchAuthorizationManagerException noSuchAuthorizationManagerException) {
            this.log.error("The DEFAULT security system was not found so we couldn't collect role analytics");
            return Collections.emptyMap();
        }
        catch (Exception e) {
            this.log.error("Unable to collect role analytics", (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

