/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.analytics.internal.handler;

import com.codahale.metrics.annotation.CachedGauge;
import com.sonatype.analytics.AnalyticsMarker;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.FeatureFlag;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.Headers;
import org.sonatype.nexus.repository.view.Response;

@Singleton
@Named(value="nexus.analytics.nuget.userAgentHandler")
@FeatureFlag(name="nexus.analytics.enabled", enabledByDefault=true)
public class AnalyticsNugetUserAgentHandler
extends ComponentSupport
implements Handler,
AnalyticsMarker {
    public static final String ANALYTICS_NUGET_USER_AGENT_HANDLER = "nexus.analytics.nuget.userAgentHandler";
    public static final String NUGET_USER_AGENT = "nuget_user_agents";
    private static final String X_NUGET_CLIENT_VERSION = "X-NuGet-Client-Version";
    private static final String USER_AGENT = "User-Agent";
    private static final String ANALYTICS_PREFIX = "nexus.analytics.";
    private final Set<Map<String, String>> envelopes = ConcurrentHashMap.newKeySet();

    @Nonnull
    public Response handle(@Nonnull Context context) throws Exception {
        try {
            this.handleAnalytics(context);
        }
        catch (Exception e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        return context.proceed();
    }

    @Override
    public void reset() {
        this.envelopes.clear();
    }

    @CachedGauge(name="nexus.analytics.nuget_user_agents", absolute=true, timeout=24L, timeoutUnit=TimeUnit.HOURS)
    public Set<Map<String, String>> envelopes() {
        return this.envelopes;
    }

    private void handleAnalytics(Context context) {
        Headers headers = context.getRequest().getHeaders();
        String xNugetClientVersion = headers.get(X_NUGET_CLIENT_VERSION);
        String userAgent = headers.get(USER_AGENT);
        if (StringUtils.isEmpty((CharSequence)xNugetClientVersion) && StringUtils.isEmpty((CharSequence)userAgent)) {
            return;
        }
        LinkedHashMap<String, String> envelope = new LinkedHashMap<String, String>();
        String repositoryName = context.getRepository().getName();
        envelope.put("repository_name", repositoryName);
        if (StringUtils.isNotEmpty((CharSequence)xNugetClientVersion)) {
            envelope.put("x_nuget_client_version", xNugetClientVersion);
        }
        if (StringUtils.isNotEmpty((CharSequence)userAgent)) {
            envelope.put("user_agent", userAgent);
        }
        this.envelopes.add(envelope);
    }
}

